/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.sync;

import com.atlassian.bitbucket.internal.mirroring.mirror.MirrorDescriptionUtils;
import com.atlassian.bitbucket.internal.mirroring.mirror.UpstreamRequestRateExceededException;
import com.atlassian.bitbucket.internal.mirroring.mirror.UpstreamRequestUntrustedException;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.MirrorProjectService;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.MirrorRepositoryService;
import com.atlassian.bitbucket.internal.mirroring.mirror.sync.RepositoriesSynchronizationRequest;
import com.atlassian.bitbucket.internal.mirroring.mirror.sync.SyncResult;
import com.atlassian.bitbucket.internal.mirroring.mirror.sync.SynchronizationHelper;
import com.atlassian.bitbucket.mirroring.mirror.ProjectSynchronizationFailedEvent;
import com.atlassian.bitbucket.mirroring.mirror.ProjectSynchronizedEvent;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamServer;
import com.atlassian.event.api.EventPublisher;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Date;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectSynchronizationHelper
implements SynchronizationHelper {
    private static final Logger log = LoggerFactory.getLogger(ProjectSynchronizationHelper.class);
    private final EventPublisher eventPublisher;
    private final String externalProjectId;
    private final MirrorProjectService mirrorProjectService;
    private final MirrorRepositoryService mirrorRepositoryService;

    ProjectSynchronizationHelper(@Nonnull String externalProjectId, @Nonnull EventPublisher eventPublisher, @Nonnull MirrorProjectService mirrorProjectService, @Nonnull MirrorRepositoryService mirrorRepositoryService) {
        this.externalProjectId = Objects.requireNonNull(externalProjectId, "externalProjectId");
        this.eventPublisher = Objects.requireNonNull(eventPublisher, "eventPublisher");
        this.mirrorProjectService = Objects.requireNonNull(mirrorProjectService, "mirrorProjectService");
        this.mirrorRepositoryService = Objects.requireNonNull(mirrorRepositoryService, "mirrorRepositoryService");
    }

    @Override
    public void deleteProjectsWithoutRepositories(@Nonnull UpstreamServer upstreamServer) {
        this.mirrorProjectService.deleteProjectIfEmpty(this.externalProjectId, Objects.requireNonNull(upstreamServer));
    }

    @Override
    @Nonnull
    public Set<String> getAllLocallyKnownExternalRepositoryIds(@Nonnull UpstreamServer upstreamServer) {
        return this.mirrorRepositoryService.getLocallyKnownExternalRepositoryIdsForProject(this.externalProjectId);
    }

    @Override
    public void notifySynchronizationComplete(@Nonnull UpstreamServer upstreamServer, @Nonnull RepositoriesSynchronizationRequest request, @Nonnull Date startDate, @Nonnull SyncResult syncResult) {
        Objects.requireNonNull(upstreamServer, "upstreamServer");
        Objects.requireNonNull(startDate, "startDate");
        Objects.requireNonNull(syncResult, "syncResult");
        this.eventPublisher.publish((Object)new ProjectSynchronizedEvent(this, this.externalProjectId, upstreamServer.getId()));
    }

    @Override
    public void notifySynchronizationFailed(@Nonnull Object source, @Nonnull UpstreamServer upstreamServer, @Nullable Date startDate, @Nonnull RuntimeException exception) {
        Objects.requireNonNull(source);
        Objects.requireNonNull(upstreamServer);
        Objects.requireNonNull(exception);
        Object upstreamDescription = MirrorDescriptionUtils.describe(upstreamServer);
        if (exception instanceof UpstreamRequestRateExceededException) {
            log.warn("{}: project synchronization failed for project with ID ({}) because an upstream request rate limit has been exceeded. Aborting project sync", upstreamDescription, (Object)this.externalProjectId);
        } else if (exception instanceof UpstreamRequestUntrustedException) {
            log.info("{}: project synchronization failed for project with ID ({}) because the upstream rejected the mirror's credentials. Perhaps the mirror is disabled in the upstream?", upstreamDescription, (Object)this.externalProjectId);
        } else {
            log.error("{}: project synchronization failed for project with ID ({})", new Object[]{upstreamDescription, this.externalProjectId, exception});
        }
        this.eventPublisher.publish((Object)new ProjectSynchronizationFailedEvent(source, this.externalProjectId, upstreamServer.getId(), exception));
    }
}

