/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.sync;

import com.atlassian.bitbucket.mirroring.mirror.SyncLevel;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.Objects;

public class RepositoriesSynchronizationRequest
implements Serializable {
    private final String externalProjectId;
    private final SyncLevel syncLevel;

    private RepositoriesSynchronizationRequest(Builder builder) {
        this.externalProjectId = builder.externalProjectId;
        this.syncLevel = Objects.requireNonNull(builder.syncLevel, "syncLevel");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepositoriesSynchronizationRequest that = (RepositoriesSynchronizationRequest)o;
        return Objects.equals(this.externalProjectId, that.externalProjectId) && this.syncLevel == that.syncLevel;
    }

    @Nonnull
    public String getExternalProjectId() {
        if (this.externalProjectId == null) {
            throw new UnsupportedOperationException("External Project Id is not applicable for full sync");
        }
        return this.externalProjectId;
    }

    @Nonnull
    public SyncLevel getSyncLevel() {
        return this.syncLevel;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.externalProjectId, this.syncLevel});
    }

    public boolean isFullSync() {
        return this.externalProjectId == null;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("externalProjectId", (Object)this.externalProjectId).add("syncLevel", (Object)this.syncLevel).toString();
    }

    public static class Builder {
        private String externalProjectId;
        private SyncLevel syncLevel = SyncLevel.DEFAULT;

        @Nonnull
        public RepositoriesSynchronizationRequest build() {
            return new RepositoriesSynchronizationRequest(this);
        }

        @Nonnull
        public Builder project(@Nullable String value) {
            this.externalProjectId = value;
            return this;
        }

        @Nonnull
        public Builder syncLevel(@Nonnull SyncLevel value) {
            this.syncLevel = Objects.requireNonNull(value, "value");
            return this;
        }
    }
}

