/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.sync;

import com.atlassian.bitbucket.internal.mirroring.mirror.ExternalProject;
import com.atlassian.bitbucket.internal.mirroring.mirror.ExternalRepository;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirrorDescriptionUtils;
import com.atlassian.bitbucket.internal.mirroring.mirror.sync.SyncLevelProvider;
import com.atlassian.bitbucket.mirroring.mirror.SyncLevel;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamServer;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.TimerUtils;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;

public class SyncContext
implements SyncLevelProvider {
    private final Map<String, Project> projects;
    private final Map<String, Repository> repositories;
    private final SyncLevelProvider syncLevelProvider;
    private final UpstreamServer upstream;

    public SyncContext(@Nonnull UpstreamServer upstream, @Nonnull SyncLevelProvider syncLevelProvider) {
        this.upstream = Objects.requireNonNull(upstream, "upstream");
        this.syncLevelProvider = Objects.requireNonNull(syncLevelProvider, "syncLevelProvider");
        this.projects = new LinkedHashMap<String, Project>();
        this.repositories = new LinkedHashMap<String, Repository>();
    }

    @Nonnull
    public Iterable<Project> getProjects() {
        return (Iterable)this.projects.values().stream().collect(MoreCollectors.toImmutableList());
    }

    @Nonnull
    public Iterable<Repository> getRepositories() {
        return (Iterable)this.repositories.values().stream().collect(MoreCollectors.toImmutableList());
    }

    @Override
    @Nonnull
    public SyncLevel getSyncLevel(@Nonnull String externalRepositoryId) {
        return this.syncLevelProvider.getSyncLevel(externalRepositoryId);
    }

    @Nonnull
    public Set<String> getSyncedExternalRepositoryIds() {
        return (Set)this.repositories.entrySet().stream().filter(entry -> entry.getValue() != null).map(Map.Entry::getKey).collect(MoreCollectors.toImmutableSet());
    }

    @Nonnull
    public UpstreamServer getUpstream() {
        return this.upstream;
    }

    public Project syncOnce(@Nonnull ExternalProject externalProject, @Nonnull BiFunction<ExternalProject, SyncContext, Project> projectSync) {
        Project project = this.projects.get(externalProject.getId());
        if (project == null) {
            project = (Project)TimerUtils.time((String)("Syncing project " + externalProject.getKey()), () -> (Project)projectSync.apply(externalProject, this));
            this.projects.putIfAbsent(externalProject.getId(), project);
        }
        return project;
    }

    @Nullable
    public Repository syncOnce(@Nonnull ExternalRepository externalRepository, @Nonnull BiFunction<ExternalRepository, SyncContext, Repository> repoSync) {
        Repository repository = this.repositories.get(externalRepository.getId());
        if (repository == null) {
            repository = (Repository)TimerUtils.time((String)("Syncing repository " + String.valueOf(MirrorDescriptionUtils.describe(externalRepository))), () -> (Repository)repoSync.apply(externalRepository, this));
            this.repositories.putIfAbsent(externalRepository.getId(), repository);
        }
        return repository;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("upstream", (Object)this.upstream).add("projects", this.projects).add("repositories", this.repositories).toString();
    }
}

