/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.sync;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Set;

public class SyncResult {
    private final Set<String> syncedExternalProjectIds;
    private final Set<String> unseenExternalRepositoryIds;
    private final Set<String> unsyncedExternalRepositoryIds;

    public SyncResult(@Nonnull Set<String> allExternalRepoIds, @Nonnull Set<String> syncedExternalRepoIds, @Nonnull Set<String> localExternalRepoIds, @Nonnull Set<String> syncedExternalProjectIds) {
        Objects.requireNonNull(allExternalRepoIds, "allExternalRepoIds");
        Objects.requireNonNull(syncedExternalProjectIds, "syncedExternalRepoIds");
        Objects.requireNonNull(localExternalRepoIds, "localExternalRepoIds");
        Objects.requireNonNull(syncedExternalProjectIds, "syncedExternalProjectIds");
        this.syncedExternalProjectIds = ImmutableSet.copyOf(syncedExternalProjectIds);
        this.unseenExternalRepositoryIds = Sets.difference(localExternalRepoIds, allExternalRepoIds);
        this.unsyncedExternalRepositoryIds = Sets.difference(allExternalRepoIds, syncedExternalRepoIds);
    }

    @Nonnull
    public Set<String> getSyncedExternalProjectIds() {
        return this.syncedExternalProjectIds;
    }

    @Nonnull
    public Set<String> getUnseenExternalRepositoryIds() {
        return this.unseenExternalRepositoryIds;
    }

    @Nonnull
    public Set<String> getUnsyncedExternalRepositoryIds() {
        return this.unsyncedExternalRepositoryIds;
    }

    public boolean isComplete() {
        return this.unsyncedExternalRepositoryIds.isEmpty() && this.unseenExternalRepositoryIds.isEmpty();
    }
}

