/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.sync;

import com.atlassian.bitbucket.internal.mirroring.mirror.repository.MirrorProjectService;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.MirrorRepositoryService;
import com.atlassian.bitbucket.internal.mirroring.mirror.sync.FullSynchronizationHelper;
import com.atlassian.bitbucket.internal.mirroring.mirror.sync.ProjectSynchronizationHelper;
import com.atlassian.bitbucket.internal.mirroring.mirror.sync.RepositoriesSynchronizationRequest;
import com.atlassian.bitbucket.internal.mirroring.mirror.sync.SynchronizationHelper;
import com.atlassian.event.api.EventPublisher;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SynchronizationHelperFactory {
    private final EventPublisher eventPublisher;
    private final MirrorProjectService mirrorProjectService;
    private final MirrorRepositoryService mirrorRepositoryService;

    @Autowired
    public SynchronizationHelperFactory(EventPublisher eventPublisher, MirrorProjectService mirrorProjectService, MirrorRepositoryService mirrorRepositoryService) {
        this.eventPublisher = eventPublisher;
        this.mirrorProjectService = mirrorProjectService;
        this.mirrorRepositoryService = mirrorRepositoryService;
    }

    @Nonnull
    public SynchronizationHelper create(@Nonnull RepositoriesSynchronizationRequest request) {
        if (Objects.requireNonNull(request).isFullSync()) {
            return new FullSynchronizationHelper(this.eventPublisher, this.mirrorProjectService, this.mirrorRepositoryService);
        }
        return new ProjectSynchronizationHelper(request.getExternalProjectId(), this.eventPublisher, this.mirrorProjectService, this.mirrorRepositoryService);
    }
}

