/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.sync;

import com.atlassian.bitbucket.concurrent.LockService;
import com.atlassian.bitbucket.internal.mirroring.mirror.UpstreamSettingsRepairer;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.UpstreamSettingRequestWrapper;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.RequestReplyTopic;
import com.atlassian.bitbucket.mirroring.mirror.IntegrationState;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamServer;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamService;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamSettings;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamSettingsGetRequest;
import com.atlassian.bitbucket.util.concurrent.LockGuard;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpstreamSettingsSyncRunner
implements JobRunner {
    private static final Logger log = LoggerFactory.getLogger(UpstreamSettingsSyncRunner.class);
    private final LockService lockService;
    private final UpstreamService upstreamService;
    private final UpstreamSettingsRepairer upstreamSettingsRepairer;
    private final RequestReplyTopic<UpstreamSettingRequestWrapper, UpstreamSettings> upstreamSettingsTopic;

    public UpstreamSettingsSyncRunner(LockService lockService, UpstreamService upstreamService, UpstreamSettingsRepairer upstreamSettingsRepairer, RequestReplyTopic<UpstreamSettingRequestWrapper, UpstreamSettings> upstreamSettingsTopic) {
        this.lockService = lockService;
        this.upstreamService = upstreamService;
        this.upstreamSettingsRepairer = upstreamSettingsRepairer;
        this.upstreamSettingsTopic = upstreamSettingsTopic;
    }

    @Nullable
    public JobRunnerResponse runJob(@Nonnull JobRunnerRequest request) {
        UpstreamServer upstreamServer = this.upstreamService.get();
        if (upstreamServer == null || upstreamServer.getState() != IntegrationState.INSTALLED) {
            log.debug("Upstream server isn't present or hasn't been installed yet, not syncing upstream settings");
            return JobRunnerResponse.success();
        }
        UpstreamSettingRequestWrapper<UpstreamSettingsGetRequest> upstreamSettingRequestWrapper = new UpstreamSettingRequestWrapper<UpstreamSettingsGetRequest>(new UpstreamSettingsGetRequest(upstreamServer.getId()), UpstreamSettingRequestWrapper.Type.GET);
        Lock lock = this.lockService.getLock("upstream_settings");
        try (LockGuard lockGuard = LockGuard.tryLock((Lock)lock);){
            if (lockGuard == null) {
                log.debug("{} lock could not be acquired. Skipping synchronization.", (Object)"upstream_settings");
                JobRunnerResponse jobRunnerResponse = JobRunnerResponse.success();
                return jobRunnerResponse;
            }
            log.debug("Sending request to all mirrors to get UpstreamSettings");
            this.upstreamSettingsTopic.publish(upstreamSettingRequestWrapper, this.upstreamSettingsRepairer);
            JobRunnerResponse jobRunnerResponse = JobRunnerResponse.success();
            return jobRunnerResponse;
        }
    }
}

