/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.sync;

import com.atlassian.bitbucket.dmz.mirror.event.MirrorBootstrappedEvent;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirroringConfig;
import com.atlassian.bitbucket.internal.mirroring.mirror.sync.UpstreamSettingsSyncRunner;
import com.atlassian.bitbucket.mirroring.mirror.AbstractEagerlyRegisteringLifecycleAware;
import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.google.common.base.Preconditions;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpstreamSettingsSyncScheduler
extends AbstractEagerlyRegisteringLifecycleAware {
    private static final Logger log = LoggerFactory.getLogger(UpstreamSettingsSyncScheduler.class);
    private static final JobId JOB_ID = JobId.of((String)UpstreamSettingsSyncRunner.class.getSimpleName());
    private static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)UpstreamSettingsSyncRunner.class.getName());
    private final MirroringConfig mirroringConfig;
    private final SchedulerService schedulerService;
    private final JobRunner upstreamSettingsSyncRunner;

    public UpstreamSettingsSyncScheduler(JobRunner upstreamSettingsSyncRunner, MirroringConfig mirroringConfig, PluginEventManager pluginEventManager, SchedulerService schedulerService) {
        super(pluginEventManager);
        this.mirroringConfig = mirroringConfig;
        this.schedulerService = schedulerService;
        this.upstreamSettingsSyncRunner = upstreamSettingsSyncRunner;
    }

    @EventListener
    public void onMirrorBootstrapped(MirrorBootstrappedEvent ignored) {
        this.schedulerService.registerJobRunner(JOB_RUNNER_KEY, this.upstreamSettingsSyncRunner);
        Duration upstreamSettingsSyncInterval = this.mirroringConfig.getUpstreamSettingsSyncInterval();
        UpstreamSettingsSyncScheduler.validate(upstreamSettingsSyncInterval);
        try {
            this.schedulerService.scheduleJob(JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.forCronExpression((String)UpstreamSettingsSyncScheduler.toCronExpression(upstreamSettingsSyncInterval))));
        }
        catch (SchedulerServiceException e) {
            log.error("Failed to schedule job with id: {}", (Object)JOB_ID, (Object)e);
        }
    }

    @Override
    public void onStop() {
        this.schedulerService.unscheduleJob(JOB_ID);
        this.schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
    }

    private static String toCronExpression(Duration duration) {
        return String.format("0 0/%s * * * ?", duration.toMinutes());
    }

    private static void validate(Duration upstreamSettingsSyncInterval) {
        long durationInMinutes = upstreamSettingsSyncInterval.toMinutes();
        Preconditions.checkArgument((durationInMinutes > 0L && durationInMinutes < 60L ? 1 : 0) != 0, (String)"Upstream Settings sync interval need to be between 1 and 59 minutes but it is set as %s minutes", (long)durationInMinutes);
    }
}

