/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.user;

import com.atlassian.bitbucket.dmz.permission.EffectivePermission;
import com.atlassian.bitbucket.dmz.permission.EffectivePermissionsProvider;
import com.atlassian.bitbucket.dmz.permission.SimpleEffectiveGlobalPermission;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirrorAuthenticationContext;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirroringUserUtils;
import com.atlassian.bitbucket.internal.mirroring.mirror.user.NoneByDefaultPermissionsVisitorAdapter;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.ApplicationUserVisitor;
import com.atlassian.bitbucket.user.ServiceUser;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Qualifier;

public class UpstreamUserPermissionSupplier
implements EffectivePermissionsProvider {
    private static Iterable<EffectivePermission> PROJ_ADMIN_AND_PROJ_CREATE = ImmutableList.of((Object)new SimpleEffectiveGlobalPermission(Permission.PROJECT_ADMIN), (Object)new SimpleEffectiveGlobalPermission(Permission.PROJECT_CREATE));
    private final MirrorAuthenticationContext mirrorAuthContext;

    public UpstreamUserPermissionSupplier(@Qualifier(value="defaultMirrorAuthenticationContext") MirrorAuthenticationContext mirrorAuthContext) {
        this.mirrorAuthContext = mirrorAuthContext;
    }

    @Nonnull
    public Iterable<EffectivePermission> getPermissions(@Nonnull ApplicationUser user) {
        return (Iterable)user.accept((ApplicationUserVisitor)new NoneByDefaultPermissionsVisitorAdapter(){

            @Override
            public Iterable<EffectivePermission> visit(@Nonnull ServiceUser user) {
                if (MirroringUserUtils.isUpstreamUser((ApplicationUser)user)) {
                    ImmutableList.Builder perms = ImmutableList.builder().addAll(PROJ_ADMIN_AND_PROJ_CREATE);
                    UpstreamUserPermissionSupplier.this.mirrorAuthContext.getImpersonatedUserHighestPermission().map(SimpleEffectiveGlobalPermission::new).ifPresent(arg_0 -> ((ImmutableList.Builder)perms).add(arg_0));
                    return perms.build();
                }
                return (Iterable)super.visit(user);
            }
        });
    }
}

