/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.vet;

import com.atlassian.bitbucket.dmz.mirror.FarmQueue;
import com.atlassian.bitbucket.dmz.mirror.hash.DmzMirrorHashService;
import com.atlassian.bitbucket.dmz.mirror.hash.MirrorHashes;
import com.atlassian.bitbucket.internal.mirroring.mirror.ExternalProject;
import com.atlassian.bitbucket.internal.mirroring.mirror.FarmVet;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamService;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirrorDescriptionUtils;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirroringConfig;
import com.atlassian.bitbucket.internal.mirroring.mirror.UpstreamUserHelper;
import com.atlassian.bitbucket.internal.mirroring.mirror.client.InternalUpstreamClient;
import com.atlassian.bitbucket.internal.mirroring.mirror.client.InternalUpstreamClientFactory;
import com.atlassian.bitbucket.internal.mirroring.mirror.client.ThreadSleeper;
import com.atlassian.bitbucket.internal.mirroring.mirror.client.UpstreamRepositoryHashesCallback;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.MetadataSynchronizer;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.metrics.JmxHelper;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization.FarmOrchestrator;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization.FarmSynchronizationRequest;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization.InitialSyncQueue;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.MirrorProjectService;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.MirrorRepositoryService;
import com.atlassian.bitbucket.internal.mirroring.mirror.vet.FarmVetJmxMetrics;
import com.atlassian.bitbucket.internal.mirroring.mirror.vet.InconsistentRepositoryHashRecorder;
import com.atlassian.bitbucket.internal.mirroring.mirror.vet.RepositorySyncDiagnosticsService;
import com.atlassian.bitbucket.internal.mirroring.mirror.vet.VetContext;
import com.atlassian.bitbucket.mirroring.mirror.RepositorySynchronizedOnFarmEvent;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamServer;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamSettings;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamSettingsService;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.scm.mirror.RepositorySynchronizationType;
import com.atlassian.event.api.EventListener;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="farmVet")
public class DefaultFarmVet
implements FarmVet {
    private static final int ID_BATCH_SIZE = 100;
    private static final Logger log = LoggerFactory.getLogger(DefaultFarmVet.class);
    private final InternalUpstreamClientFactory clientFactory;
    private final Set<String> consistencyTracker;
    private final Executor executor;
    private final FarmVetJmxMetrics farmVetJmxMetrics;
    private final DmzMirrorHashService hashService;
    private final InitialSyncQueue initialSyncQueue;
    private final MirroringConfig mirroringConfig;
    private final MetadataSynchronizer metadataSynchronizer;
    private final FarmOrchestrator orchestrator;
    private final MirrorProjectService projectService;
    private final FarmQueue<FarmSynchronizationRequest> refChangesQueue;
    private final MirrorRepositoryService repositoryService;
    private final RepositorySyncDiagnosticsService repositorySyncDiagnosticsService;
    private final UpstreamSettingsService settingsService;
    private final InternalUpstreamService upstreamService;
    private final UpstreamUserHelper userHelper;

    @Autowired
    public DefaultFarmVet(InternalUpstreamClientFactory clientFactory, FarmVetJmxMetrics farmVetJmxMetrics, DmzMirrorHashService hashService, MetadataSynchronizer metadataSynchronizer, FarmOrchestrator orchestrator, MirrorProjectService projectService, MirrorRepositoryService repositoryService, UpstreamSettingsService settingsService, InternalUpstreamService upstreamService, UpstreamUserHelper userHelper, FarmQueue<FarmSynchronizationRequest> refChangesQueue, @Qualifier(value="farmVetExecutor") Executor executor, InitialSyncQueue initialSyncQueue, MirroringConfig mirroringConfig, RepositorySyncDiagnosticsService repositorySyncDiagnosticsService) {
        this.clientFactory = clientFactory;
        this.farmVetJmxMetrics = farmVetJmxMetrics;
        this.executor = executor;
        this.hashService = hashService;
        this.metadataSynchronizer = metadataSynchronizer;
        this.orchestrator = orchestrator;
        this.repositoryService = repositoryService;
        this.settingsService = settingsService;
        this.upstreamService = upstreamService;
        this.userHelper = userHelper;
        this.projectService = projectService;
        this.initialSyncQueue = initialSyncQueue;
        this.refChangesQueue = refChangesQueue;
        this.mirroringConfig = mirroringConfig;
        this.repositorySyncDiagnosticsService = repositorySyncDiagnosticsService;
        this.consistencyTracker = new ConcurrentSkipListSet<String>();
    }

    @EventListener
    public void onRepositorySynchronizedOnFarm(RepositorySynchronizedOnFarmEvent event) {
        if (event.getSyncType() == RepositorySynchronizationType.SNAPSHOT && event.getRefChanges().isEmpty()) {
            this.upstreamService.refreshContentHash(event.getExternalRepositoryId());
        }
    }

    @Override
    public void synchronize(@Nonnull UpstreamServer upstreamServer, boolean firstRun) {
        log.debug("Running farm vet");
        this.userHelper.performAsUpstreamUser(upstreamServer.getId(), () -> {
            UpstreamSettings settings = this.settingsService.getSettingsOrFail(upstreamServer.getId());
            this.farmVetJmxMetrics.markRun();
            try (VetContext context = new VetContext(this.executor, this.consistencyTracker, upstreamServer, firstRun, this.farmVetJmxMetrics, this.metadataSynchronizer, this.mirroringConfig, this.orchestrator, this.refChangesQueue, this.repositoryService, new ThreadSleeper());
                 Ticker ignored = Timers.timerWithMetric((String)JmxHelper.timerNameGrouped("farm", "vet")).start(new String[0]);){
                InternalUpstreamClient client = this.clientFactory.create(upstreamServer);
                client.streamHashes(new ServerUpstreamRepositoryHashesCallback(context, settings::isMirrored, client));
            }
            if (this.upstreamService.updateLastFullSyncDate(upstreamServer.getId(), new Date()) == null) {
                log.error("Failed to update last synchronization date for upstream {}", MirrorDescriptionUtils.describe(upstreamServer));
            }
            return null;
        });
    }

    private class ServerUpstreamRepositoryHashesCallback
    implements UpstreamRepositoryHashesCallback {
        private final VetContext context;
        private final Predicate<String> isMirrored;
        private final Map<Integer, UpstreamHashes> pendingHashes;
        private final Map<String, Boolean> pendingMetadata;
        private final InternalUpstreamClient upstreamClient;
        private InconsistentRepositoryHashRecorder inconsistentHashRecorder;
        private Map<String, Integer> repositoryIdsByExternalId;

        ServerUpstreamRepositoryHashesCallback(VetContext context, Predicate<String> isMirrored, InternalUpstreamClient upstreamClient) {
            this.context = context;
            this.upstreamClient = upstreamClient;
            this.isMirrored = isMirrored;
            this.pendingHashes = new HashMap<Integer, UpstreamHashes>(100, 1.0f);
            this.pendingMetadata = new HashMap<String, Boolean>(100, 1.0f);
        }

        @Override
        public void onEnd(@Nonnull Instant lastModified) {
            if (!this.pendingHashes.isEmpty()) {
                this.checkHashes();
            }
            if (!this.pendingMetadata.isEmpty()) {
                this.synchronizeMetadata();
            }
            this.inconsistentHashRecorder.end();
        }

        @Override
        public boolean onProject(@Nonnull String projectId, boolean publiclyAccessible) {
            boolean projectSyncing = DefaultFarmVet.this.projectService.isProjectSyncing(projectId, this.context.getUpstream());
            if (projectSyncing && DefaultFarmVet.this.initialSyncQueue.hasPendingRequests() || !this.isMirrored.test(projectId)) {
                this.repositoryIdsByExternalId = null;
                return false;
            }
            Project localProject = DefaultFarmVet.this.projectService.getLocalProject(projectId, this.context.getUpstream());
            if (localProject == null) {
                this.repositoryIdsByExternalId = Collections.emptyMap();
            } else {
                this.repositoryIdsByExternalId = new HashMap<String, Integer>(DefaultFarmVet.this.projectService.mapRepositoryIdsForProject(localProject));
                if (publiclyAccessible != localProject.isPublic()) {
                    try {
                        ExternalProject project = this.upstreamClient.getProject(projectId);
                        this.context.synchronizeMetadata(project);
                    }
                    catch (Exception e) {
                        log.warn("Failed to retrieve metadata for synchronization of project with ID ({})", (Object)projectId, (Object)e);
                    }
                }
            }
            return true;
        }

        @Override
        public void onRepository(@Nonnull String repositoryId, @Nonnull String contentHash, @Nullable Date contentUpdatedDate, @Nonnull String metadataHash, @Nullable Date metadataUpdatedDate) {
            Objects.requireNonNull(repositoryId, "repositoryId");
            Objects.requireNonNull(contentHash, "contentHash");
            Objects.requireNonNull(metadataHash, "metadataHash");
            if (this.repositoryIdsByExternalId == null) {
                return;
            }
            Integer localId = this.repositoryIdsByExternalId.remove(repositoryId);
            if (localId == null) {
                this.queueForMetadata(repositoryId, true);
            } else if (!contentHash.equals(DmzMirrorHashService.NULL_HASH) || !metadataHash.equals(DmzMirrorHashService.NULL_HASH)) {
                this.pendingHashes.put(localId, new UpstreamHashes(this, repositoryId, contentHash, metadataHash, contentUpdatedDate));
                if (this.pendingHashes.size() >= 100) {
                    this.checkHashes();
                }
            }
        }

        @Override
        public void onStart() {
            this.inconsistentHashRecorder = DefaultFarmVet.this.repositorySyncDiagnosticsService.createInconsistentHashRecorder();
        }

        private void checkHashes() {
            Map localHashesByRepository = DefaultFarmVet.this.hashService.mapHashesByRepositoryId(this.pendingHashes.keySet());
            this.pendingHashes.forEach((localId, upstreamHashes) -> {
                MirrorHashes localHashes = (MirrorHashes)localHashesByRepository.get(localId);
                if (localHashes == null) {
                    log.warn("Repository with ID ({}) maps to local ID [{}], but the repository does not exist", (Object)upstreamHashes.externalId, localId);
                    this.queueForMetadata(upstreamHashes.externalId, true);
                } else {
                    boolean syncContents = upstreamHashes.contentsUpdated(localHashes.getContent());
                    if (syncContents && !this.context.isFirstRun()) {
                        this.recordInconsistentRepository((Integer)localId, (UpstreamHashes)upstreamHashes, localHashes);
                        if (!DefaultFarmVet.this.consistencyTracker.contains(upstreamHashes.externalId)) {
                            DefaultFarmVet.this.consistencyTracker.add(upstreamHashes.externalId);
                            syncContents = false;
                        }
                    } else {
                        DefaultFarmVet.this.consistencyTracker.remove(upstreamHashes.externalId);
                    }
                    if (upstreamHashes.metadataUpdated(localHashes.getMetadata())) {
                        this.queueForMetadata(upstreamHashes.externalId, syncContents);
                    } else if (syncContents) {
                        this.context.synchronizeContents(upstreamHashes.externalId);
                    }
                }
            });
            this.pendingHashes.clear();
        }

        private void queueForMetadata(String externalId, boolean syncContents) {
            this.pendingMetadata.put(externalId, syncContents);
            if (this.pendingMetadata.size() >= 100) {
                this.synchronizeMetadata();
            }
        }

        private void recordInconsistentRepository(Integer localId, UpstreamHashes upstreamHashes, MirrorHashes localHashes) {
            this.inconsistentHashRecorder.record(localId, upstreamHashes.externalId, (Date)ObjectUtils.firstNonNull((Object[])new Date[]{upstreamHashes.contentUpdatedDate, new Date()}), localHashes.getContent(), (Date)ObjectUtils.firstNonNull((Object[])new Date[]{localHashes.getContentUpdatedDate(), new Date()}));
        }

        private void synchronizeMetadata() {
            HashMap<String, Boolean> queue = new HashMap<String, Boolean>(this.pendingMetadata);
            this.pendingMetadata.clear();
            this.context.submit(() -> {
                queue.forEach((externalRepositoryId, syncContents) -> {
                    try {
                        this.context.synchronizeMetadata(this.upstreamClient.getRepository((String)externalRepositoryId), (boolean)syncContents);
                    }
                    catch (Exception e) {
                        log.warn("Failed to retrieve metadata for synchronization of repository with ID ({})", externalRepositoryId, (Object)e);
                    }
                });
                return null;
            });
        }

        private class UpstreamHashes {
            private final String content;
            private final Date contentUpdatedDate;
            private final String externalId;
            private final String metadata;

            UpstreamHashes(ServerUpstreamRepositoryHashesCallback serverUpstreamRepositoryHashesCallback, String externalId, String content, String metadata, Date contentUpdatedDate) {
                this.content = content;
                this.contentUpdatedDate = contentUpdatedDate;
                this.externalId = externalId;
                this.metadata = metadata;
            }

            boolean contentsUpdated(String hash) {
                return hash.equals(DmzMirrorHashService.NULL_HASH) || this.isUpdated(hash, this.content);
            }

            boolean metadataUpdated(String hash) {
                return this.isUpdated(hash, this.metadata);
            }

            private boolean isUpdated(String local, String upstream) {
                return !upstream.equals(DmzMirrorHashService.NULL_HASH) && !upstream.equals(local);
            }
        }
    }
}

