/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.vet;

import com.atlassian.bitbucket.internal.mirroring.mirror.MirroringConfig;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.operation.MirrorOperation;
import com.atlassian.bitbucket.internal.mirroring.mirror.vet.DelayedSyncRepositoriesQuery;
import com.atlassian.bitbucket.internal.mirroring.mirror.vet.DelayedSyncRepositoriesResult;
import com.atlassian.bitbucket.internal.mirroring.mirror.vet.RepositorySyncDiagnosticsService;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DelayedSyncRepositoriesQueryOperation
implements MirrorOperation<DelayedSyncRepositoriesQuery, DelayedSyncRepositoriesResult> {
    private static final Logger log = LoggerFactory.getLogger(DelayedSyncRepositoriesQueryOperation.class);
    private final MirroringConfig mirroringConfig;
    private final RepositorySyncDiagnosticsService repositorySyncDiagnosticsService;

    public DelayedSyncRepositoriesQueryOperation(MirroringConfig mirroringConfig, RepositorySyncDiagnosticsService repositorySyncDiagnosticsService) {
        this.mirroringConfig = mirroringConfig;
        this.repositorySyncDiagnosticsService = repositorySyncDiagnosticsService;
    }

    @Override
    @Nonnull
    public DelayedSyncRepositoriesResult perform(@Nonnull DelayedSyncRepositoriesQuery request) {
        Objects.requireNonNull(request, "request");
        if (this.mirroringConfig.isRepositorySyncDiagnosticsEnabled()) {
            Set<String> delayedSyncRepositories = this.repositorySyncDiagnosticsService.getLocalDelayedSyncRepositories(request.limit(), request.delayedSyncThresholdSeconds() > 0 ? Duration.ofSeconds(request.delayedSyncThresholdSeconds()) : null);
            return new DelayedSyncRepositoriesResult(delayedSyncRepositories);
        }
        log.warn("Trying to query delayed sync repositories but the feature is disabled, returning empty results");
        return new DelayedSyncRepositoriesResult(Set.of());
    }
}

