/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.vet;

import com.atlassian.bitbucket.ServerException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.NodeVmId;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.RequestReplyTopic;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.result.ConflictResults;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.result.ErrorResult;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.result.ResultVisitor;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.result.SingleResult;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.result.TimeoutResult;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.MirrorRepositoryService;
import com.atlassian.bitbucket.internal.mirroring.mirror.vet.DelayedSyncRepositoriesQuery;
import com.atlassian.bitbucket.internal.mirroring.mirror.vet.DelayedSyncRepositoriesResult;
import com.atlassian.bitbucket.internal.mirroring.mirror.vet.InvalidDelayedSyncThresholdException;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DelayedSyncRepositoriesQueryService {
    public static final int MAX_DELAYED_SYNC_RESULTS = 100;
    private static final Logger log = LoggerFactory.getLogger(DelayedSyncRepositoriesQueryService.class);
    private final I18nService i18nService;
    private final MirrorRepositoryService mirrorRepositoryService;
    private final PermissionValidationService permissionValidationService;
    private final RequestReplyTopic<DelayedSyncRepositoriesQuery, DelayedSyncRepositoriesResult> topic;

    @Autowired
    public DelayedSyncRepositoriesQueryService(I18nService i18nService, MirrorRepositoryService mirrorRepositoryService, PermissionValidationService permissionValidationService, RequestReplyTopic<DelayedSyncRepositoriesQuery, DelayedSyncRepositoriesResult> topic) {
        this.i18nService = i18nService;
        this.mirrorRepositoryService = mirrorRepositoryService;
        this.permissionValidationService = permissionValidationService;
        this.topic = topic;
    }

    @Nonnull
    public Map<String, Repository> getDelayedSyncRepositories(int limit, int delayedSyncThresholdSeconds) {
        this.permissionValidationService.validateForGlobal(Permission.ADMIN);
        if (limit > 100) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.mirroring.repository.diagnostics.max.results.error", new Object[]{100}));
        }
        Set<String> delayedRepositoryIds = this.topic.publish(new DelayedSyncRepositoriesQuery(limit, delayedSyncThresholdSeconds), new DelayedSyncRepositoriesResultVisitor(limit));
        Map<String, Repository> delayedRepositories = this.mirrorRepositoryService.mapToLocalRepositories(delayedRepositoryIds);
        if (delayedRepositoryIds.size() != delayedRepositories.size()) {
            Sets.difference(delayedRepositoryIds, delayedRepositories.keySet()).forEach(repoId -> log.warn("Repository with ID ({}) could not be found locally even though it is delayed sync on one or more other nodes", repoId));
        }
        return delayedRepositories;
    }

    private class DelayedSyncRepositoriesResultVisitor
    implements ResultVisitor<DelayedSyncRepositoriesResult, Set<String>> {
        private final int limit;

        public DelayedSyncRepositoriesResultVisitor(int limit) {
            this.limit = limit;
        }

        @Override
        @Nonnull
        public Set<String> visit(SingleResult<DelayedSyncRepositoriesResult> result) {
            return result.get().repositoryIds();
        }

        @Override
        @Nonnull
        public Set<String> visit(ConflictResults<DelayedSyncRepositoriesResult> results) {
            log.debug("Received conflicting results for delayed sync repositories on different nodes: {}", results.getResults());
            return this.summarize(results.getResults());
        }

        @Override
        @Nonnull
        public Set<String> visit(TimeoutResult<DelayedSyncRepositoriesResult> results) {
            log.warn("Timed out while fetching delayed sync repositories from nodes: {} with errors: [{}]", results.getLost(), results.getErrors());
            return this.summarize(results.getResults());
        }

        @Override
        @Nonnull
        public Set<String> visit(ErrorResult<DelayedSyncRepositoriesResult> results) {
            if (results.getResults().isEmpty()) {
                if (results.getErrors().containsKey(InvalidDelayedSyncThresholdException.class)) {
                    throw new InvalidDelayedSyncThresholdException(DelayedSyncRepositoriesQueryService.this.i18nService.createKeyedMessage("bitbucket.mirroring.repository.diagnostics.sync.invalid.threshold.orchestrator", new Object[0]));
                }
                throw new ServerException(DelayedSyncRepositoriesQueryService.this.i18nService.createKeyedMessage("bitbucket.mirroring.repository.diagnostics.sync.unknown.error", new Object[0]));
            }
            log.error("Error while fetching delayed sync repositories from one or more nodes due to following errors: [{}]", results.getErrors());
            return this.summarize(results.getResults());
        }

        private Set<String> summarize(Map<DelayedSyncRepositoriesResult, List<NodeVmId>> results) {
            return results.keySet().stream().map(DelayedSyncRepositoriesResult::repositoryIds).flatMap(Collection::stream).distinct().sorted().limit(this.limit).collect(Collectors.toUnmodifiableSet());
        }
    }
}

