/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.vet;

import com.atlassian.bitbucket.internal.mirroring.mirror.farm.metrics.JmxHelper;
import com.atlassian.bitbucket.internal.mirroring.mirror.vet.FarmVetMXBean;
import java.util.concurrent.atomic.LongAdder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FarmVetJmxMetrics
implements FarmVetMXBean {
    static final String CATEGORY = "farm";
    static final String NAME = "vet";
    private final LongAdder projectMetadataRepairs;
    private final LongAdder repositoryContentRepairs;
    private final LongAdder repositoryMetadataRepairs;
    private final LongAdder runs = new LongAdder();

    @Autowired
    public FarmVetJmxMetrics(JmxHelper jmxHelper) {
        this.repositoryContentRepairs = new LongAdder();
        this.repositoryMetadataRepairs = new LongAdder();
        this.projectMetadataRepairs = new LongAdder();
        jmxHelper.maybeRegisterCounterMBean(CATEGORY, NAME, this);
    }

    @Override
    public long getProjectMetadataRepairs() {
        return this.projectMetadataRepairs.longValue();
    }

    @Override
    public long getRepositoryContentRepairs() {
        return this.repositoryContentRepairs.longValue();
    }

    @Override
    public long getRepositoryMetadataRepairs() {
        return this.repositoryMetadataRepairs.longValue();
    }

    @Override
    public long getRuns() {
        return this.runs.longValue();
    }

    void markProjectMetadataRepair() {
        this.projectMetadataRepairs.increment();
    }

    void markRepositoryContentRepair() {
        this.repositoryContentRepairs.increment();
    }

    void markRepositoryMetadataRepair() {
        this.repositoryMetadataRepairs.increment();
    }

    void markRun() {
        this.runs.increment();
    }
}

