/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.vet;

import com.atlassian.bitbucket.FeatureDisabledException;
import com.atlassian.bitbucket.dmz.mirror.hash.DmzMirrorHashService;
import com.atlassian.bitbucket.dmz.mirror.hash.MirrorHash;
import com.atlassian.bitbucket.dmz.mirror.hash.MirrorHashType;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirroringConfig;
import com.atlassian.bitbucket.internal.mirroring.mirror.vet.InconsistentRepositoryHashRecorder;
import com.atlassian.bitbucket.internal.mirroring.mirror.vet.InvalidDelayedSyncThresholdException;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.google.common.base.Preconditions;
import com.google.common.collect.Comparators;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalAmount;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.stream.Streams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="repositorySyncDiagnosticsService")
public class RepositorySyncDiagnosticsService {
    public static final int HASHES_BATCH_SIZE = 100;
    private static final Logger log = LoggerFactory.getLogger(RepositorySyncDiagnosticsService.class);
    private static final InconsistentRepositoryHashRecorder NO_OP_RECORDER = new InconsistentRepositoryHashRecorder(){

        @Override
        public void end() {
        }

        @Override
        public void record(int localRepoId, @Nonnull String externalRepositoryId, @Nonnull Date upstreamHashUpdateDate, @Nonnull String mirrorHash, @Nonnull Date mirrorHashUpdatedDate) {
        }
    };
    private final Duration delayedSyncTolerance;
    private final I18nService i18nService;
    private final DmzMirrorHashService mirrorHashService;
    private final MirroringConfig mirroringConfig;
    private final Duration syncInterval;
    private volatile Map<Integer, InconsistentHash> mirrorAndUpstreamHashes;

    @Autowired
    public RepositorySyncDiagnosticsService(DmzMirrorHashService mirrorHashService, MirroringConfig mirroringConfig, I18nService i18nService) {
        this.i18nService = i18nService;
        this.mirrorHashService = mirrorHashService;
        this.mirroringConfig = mirroringConfig;
        this.syncInterval = mirroringConfig.getSyncInterval();
        this.delayedSyncTolerance = (Duration)Comparators.max((Comparable)mirroringConfig.getRepositoryDiagnosticsSyncTolerance(), (Comparable)this.syncInterval);
        this.mirrorAndUpstreamHashes = Collections.emptyMap();
    }

    @Nonnull
    public InconsistentRepositoryHashRecorder createInconsistentHashRecorder() {
        if (this.mirroringConfig.isRepositorySyncDiagnosticsEnabled()) {
            return new DiagnosticsInconsistentRepositoryHashRecorder(this.mirrorAndUpstreamHashes, x -> {
                this.mirrorAndUpstreamHashes = ImmutableMap.copyOf((Map)x);
            });
        }
        return NO_OP_RECORDER;
    }

    @Nonnull
    public Set<String> getLocalDelayedSyncRepositories() {
        return this.getLocalDelayedSyncRepositories(Integer.MAX_VALUE, this.delayedSyncTolerance);
    }

    @Nonnull
    public Set<String> getLocalDelayedSyncRepositories(int limit, @Nullable Duration delayedSyncThreshold) {
        Preconditions.checkArgument((limit > 0 ? 1 : 0) != 0, (Object)"limit should be greater than 0");
        if (!this.mirroringConfig.isRepositorySyncDiagnosticsEnabled()) {
            throw new FeatureDisabledException(this.i18nService.createKeyedMessage("bitbucket.mirroring.repository.diagnostics.sync.disabled.error", new Object[0]));
        }
        this.validateDelayedSyncThreshold(delayedSyncThreshold);
        Instant inconsistencyLimit = Instant.now().minus((TemporalAmount)ObjectUtils.firstNonNull((Object[])new Duration[]{delayedSyncThreshold, this.delayedSyncTolerance}));
        Stream delayedRepositoryIds = Streams.of((Iterator)Iterators.partition(this.mirrorAndUpstreamHashes.entrySet().stream().filter(e -> {
            InconsistentHash recordedHash = (InconsistentHash)e.getValue();
            return recordedHash.upstreamHashUpdatedDate.toInstant().isBefore(inconsistencyLimit) && recordedHash.mirrorHashUpdatedDate.toInstant().isBefore(inconsistencyLimit);
        }).sorted(Comparator.comparing(e -> ((InconsistentHash)e.getValue()).externalRepositoryId)).iterator(), (int)100)).flatMap(batch -> {
            Set repoIds = batch.stream().map(Map.Entry::getKey).collect(Collectors.toUnmodifiableSet());
            Map mirrorHashes = this.mirrorHashService.mapHashesByRepositoryId(repoIds, MirrorHashType.CONTENT, null);
            return batch.stream().map(e -> {
                InconsistentHash recordedHash = (InconsistentHash)e.getValue();
                return RepositorySyncDiagnosticsService.sameMirrorHash(recordedHash, (MirrorHash)mirrorHashes.get(e.getKey())) ? recordedHash.externalRepositoryId : null;
            }).filter(Objects::nonNull);
        });
        if (limit == Integer.MAX_VALUE) {
            return (Set)delayedRepositoryIds.collect(MoreCollectors.toImmutableSet());
        }
        return (Set)delayedRepositoryIds.limit(limit).collect(MoreCollectors.toImmutableSet());
    }

    private static boolean sameMirrorHash(InconsistentHash recorded, MirrorHash current) {
        if (current == null) {
            return false;
        }
        return Objects.equals(current.getHash(), recorded.mirrorHash) && Objects.equals(current.getUpdatedDate(), recorded.mirrorHashUpdatedDate);
    }

    private void validateDelayedSyncThreshold(Duration delayedSyncThreshold) {
        if (delayedSyncThreshold != null && delayedSyncThreshold.compareTo(this.syncInterval) < 0) {
            throw new InvalidDelayedSyncThresholdException(this.i18nService.createKeyedMessage("bitbucket.mirroring.repository.diagnostics.sync.invalid.threshold", new Object[]{delayedSyncThreshold.getSeconds(), this.syncInterval.getSeconds()}));
        }
    }

    private static class DiagnosticsInconsistentRepositoryHashRecorder
    implements InconsistentRepositoryHashRecorder {
        private final Map<Integer, InconsistentHash> currentInconsistentHashes;
        private final Consumer<Map<Integer, InconsistentHash>> onEndConsumer;
        private final Map<Integer, InconsistentHash> updatedMirrorAndUpstreamHashes;

        private DiagnosticsInconsistentRepositoryHashRecorder(Map<Integer, InconsistentHash> currentInconsistentHashes, Consumer<Map<Integer, InconsistentHash>> onEndConsumer) {
            this.currentInconsistentHashes = currentInconsistentHashes;
            this.onEndConsumer = onEndConsumer;
            this.updatedMirrorAndUpstreamHashes = new ConcurrentHashMap<Integer, InconsistentHash>();
        }

        @Override
        public void end() {
            this.onEndConsumer.accept(this.updatedMirrorAndUpstreamHashes);
        }

        @Override
        public void record(int localRepoId, @Nonnull String externalRepositoryId, @Nonnull Date upstreamHashUpdateDate, @Nonnull String mirrorHash, @Nonnull Date mirrorHashUpdatedDate) {
            Objects.requireNonNull(externalRepositoryId, "externalRepositoryId");
            Objects.requireNonNull(upstreamHashUpdateDate, "upstreamHashUpdateDate");
            Objects.requireNonNull(mirrorHash, "mirrorHash");
            Objects.requireNonNull(mirrorHashUpdatedDate, "mirrorHashUpdatedDate");
            log.trace("Recording inconsistent hash for repository with ID ({})", (Object)externalRepositoryId);
            InconsistentHash newHash = new InconsistentHash(externalRepositoryId, mirrorHash, upstreamHashUpdateDate, mirrorHashUpdatedDate);
            InconsistentHash inconsistentHash = this.currentInconsistentHashes.getOrDefault(localRepoId, newHash);
            if (mirrorHash.equals(inconsistentHash.mirrorHash)) {
                this.updatedMirrorAndUpstreamHashes.put(localRepoId, inconsistentHash);
            } else {
                this.updatedMirrorAndUpstreamHashes.put(localRepoId, newHash);
            }
        }
    }

    private record InconsistentHash(String externalRepositoryId, String mirrorHash, Date upstreamHashUpdatedDate, Date mirrorHashUpdatedDate) {
    }
}

