/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.vet;

import com.atlassian.bitbucket.dmz.mirror.FarmQueue;
import com.atlassian.bitbucket.internal.mirroring.mirror.BackoffUtils;
import com.atlassian.bitbucket.internal.mirroring.mirror.ExternalProject;
import com.atlassian.bitbucket.internal.mirroring.mirror.ExternalRepository;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirrorDescriptionUtils;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirroringConfig;
import com.atlassian.bitbucket.internal.mirroring.mirror.client.Sleeper;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.MetadataSynchronizer;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.queue.DefaultFarmQueueRequest;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.queue.RequestState;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.queue.RequestStatus;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization.FarmOrchestrator;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization.FarmSynchronizationRequest;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.MirrorRepositoryService;
import com.atlassian.bitbucket.internal.mirroring.mirror.sync.SyncContext;
import com.atlassian.bitbucket.internal.mirroring.mirror.vet.FarmVetJmxMetrics;
import com.atlassian.bitbucket.mirroring.mirror.SyncLevel;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamServer;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.mirror.RepositorySynchronizationType;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VetContext
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(VetContext.class);
    private final CompletionService<Object> completionService;
    private final Set<String> consistencyTracker;
    private final FarmVetJmxMetrics farmVetJmxMetrics;
    private final boolean firstRun;
    private final MetadataSynchronizer metadataSynchronizer;
    private final MirroringConfig mirroringConfig;
    private final FarmOrchestrator orchestrator;
    private final FarmQueue<FarmSynchronizationRequest> refChangesQueue;
    private final MirrorRepositoryService repositoryService;
    private final AtomicInteger running;
    private final Sleeper sleeper;
    private final SyncContext syncContext;

    VetContext(Executor executor, Set<String> consistencyTracker, UpstreamServer upstreamServer, boolean firstRun, FarmVetJmxMetrics farmVetJmxMetrics, MetadataSynchronizer metadataSynchronizer, MirroringConfig mirroringConfig, FarmOrchestrator orchestrator, FarmQueue<FarmSynchronizationRequest> refChangesQueue, MirrorRepositoryService repositoryService, Sleeper sleeper) {
        this.consistencyTracker = consistencyTracker;
        this.firstRun = firstRun;
        this.farmVetJmxMetrics = farmVetJmxMetrics;
        this.metadataSynchronizer = metadataSynchronizer;
        this.mirroringConfig = mirroringConfig;
        this.orchestrator = orchestrator;
        this.refChangesQueue = refChangesQueue;
        this.repositoryService = repositoryService;
        this.sleeper = sleeper;
        this.completionService = new ExecutorCompletionService<Object>(executor);
        this.running = new AtomicInteger();
        this.syncContext = new SyncContext(upstreamServer, ignored -> SyncLevel.DEFAULT);
    }

    @Override
    public void close() {
        int remaining = this.running.get();
        while (remaining > 0) {
            try {
                this.completionService.take();
                remaining = this.running.decrementAndGet();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.warn("Interrupted while waiting for synchronization tasks to complete");
                break;
            }
        }
        log.trace("Exiting VetContext");
    }

    UpstreamServer getUpstream() {
        return this.syncContext.getUpstream();
    }

    boolean isFirstRun() {
        return this.firstRun;
    }

    void submit(Callable<Object> task) {
        this.completionService.submit(task);
        this.running.incrementAndGet();
    }

    void synchronizeContents(String externalRepositoryId) {
        this.synchronizeContents(externalRepositoryId, RepositorySynchronizationType.SNAPSHOT);
    }

    void synchronizeMetadata(ExternalProject externalProject) {
        this.farmVetJmxMetrics.markProjectMetadataRepair();
        log.debug("{}: Detected metadata inconsistency in project, repairing", MirrorDescriptionUtils.describe(externalProject));
        this.metadataSynchronizer.synchronizeProject(externalProject, this.syncContext);
    }

    void synchronizeMetadata(ExternalRepository externalRepository, boolean syncContent) {
        if (externalRepository == null) {
            return;
        }
        this.farmVetJmxMetrics.markRepositoryMetadataRepair();
        log.debug("{}: Detected metadata inconsistency in repository, repairing", MirrorDescriptionUtils.describe(externalRepository));
        Repository localRepository = this.metadataSynchronizer.synchronizeRepository(externalRepository, this.syncContext);
        if (syncContent) {
            this.synchronizeContents(externalRepository.getId(), RepositorySynchronizationType.SNAPSHOT);
        } else if (this.isDefaultBranchChanged(localRepository, externalRepository)) {
            log.debug("{}: Detected incorrect default branch for repository, repairing", MirrorDescriptionUtils.describe(externalRepository));
            this.synchronizeContents(externalRepository.getId(), RepositorySynchronizationType.INCREMENTAL);
        }
    }

    private void enqueueSynchronizationRequest(FarmSynchronizationRequest syncRequest) {
        log.warn("Farm Vet couldn't fix inconsistency for repository with ID ({}). A SNAPSHOT synchronisation request will be queued.", (Object)syncRequest.getExternalRepositoryId());
        if (!this.refChangesQueue.offer(new DefaultFarmQueueRequest<FarmSynchronizationRequest>(syncRequest))) {
            log.error("Unable to submit request for Ref Changes for repository with ID ({}) as queue is full", (Object)syncRequest.getExternalRepositoryId());
        }
    }

    private boolean isDefaultBranchChanged(Repository local, ExternalRepository external) {
        return external.getDefaultBranchId().map(upstreamDefault -> !upstreamDefault.equals(this.repositoryService.getDefaultBranch(local).orElse(null))).orElse(false);
    }

    private RequestStatus retrySynchronizeContents(FarmSynchronizationRequest syncRequest) throws InterruptedException {
        RequestStatus requestStatus = null;
        for (int i = 0; i < this.mirroringConfig.getFarmVetFirstRunRetryAttempts(); ++i) {
            requestStatus = this.orchestrator.orchestrateChanges(syncRequest);
            if (requestStatus.equals(RequestStatus.processed())) {
                log.debug("Farm Vet successfully fixed inconsistency for repository with ID ({}) on retry attempt {}", (Object)syncRequest.getExternalRepositoryId(), (Object)i);
                break;
            }
            long backoff = BackoffUtils.exponentialDelay(1000L, i);
            log.debug("Farm Orchestration run by Farm Vet didn't succeed for repository with ID ({}) due to {} on retry attempt {}. Waiting for {}ms.", new Object[]{syncRequest.getExternalRepositoryId(), requestStatus, i, backoff});
            this.sleeper.sleep(backoff);
        }
        if (!requestStatus.equals(RequestStatus.processed())) {
            this.enqueueSynchronizationRequest(syncRequest);
        }
        return requestStatus;
    }

    private RequestStatus retrySynchronizeContentsAsync(FarmSynchronizationRequest syncRequest) {
        RequestStatus requestStatus = this.orchestrator.orchestrateChanges(syncRequest);
        if (!requestStatus.getState().equals((Object)RequestState.PROCESSED)) {
            this.enqueueSynchronizationRequest(syncRequest);
        }
        return requestStatus;
    }

    private void synchronizeContents(String externalRepositoryId, RepositorySynchronizationType type) {
        log.debug("Detected content inconsistency in repository with ID ({}), repairing", (Object)externalRepositoryId);
        this.farmVetJmxMetrics.markRepositoryContentRepair();
        this.consistencyTracker.remove(externalRepositoryId);
        this.submit(() -> {
            FarmSynchronizationRequest syncRequest = new FarmSynchronizationRequest(externalRepositoryId, type);
            if (this.firstRun) {
                return this.retrySynchronizeContents(syncRequest);
            }
            return this.retrySynchronizeContentsAsync(syncRequest);
        });
    }
}

