/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.web;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamServer;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamService;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.google.common.collect.ImmutableSet;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class MirrorInterceptorFilter
implements Filter {
    static final Pattern PATH_WEB_ERROR = Pattern.compile("/error[0-9]+");
    static final String PATH_WEB_MIRROR = "/mirror";
    static final Set<String> PATH_WEB_WHITELIST = ImmutableSet.of((Object)"/mirror", (Object)"/about", (Object)"/system/startup", (Object)"/unavailable", (Object)"/plugins/servlet/admin/mirror", (Object)"/plugins/servlet/admin/mirror/dialog", (Object[])new String[]{"/status"});
    static final String PATH_PLACEHOLDER_PAGE = "/plugins/servlet/mirror-placeholder";
    static final String PATH_REST = "/rest/";
    static final String PATH_WEB_ATST = "/plugins/servlet/troubleshooting";
    private static final Logger log = LoggerFactory.getLogger(MirrorInterceptorFilter.class);
    private final ApplicationPropertiesService propertiesService;
    private final UpstreamService upstreamService;
    private String upstreamBaseUrl;

    public MirrorInterceptorFilter(ApplicationPropertiesService propertiesService, UpstreamService upstreamService) {
        this.propertiesService = propertiesService;
        this.upstreamService = upstreamService;
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (!this.propertiesService.isSetup()) {
            chain.doFilter(request, response);
            return;
        }
        String relativePath = this.getRelativePath(httpRequest);
        if (PATH_WEB_MIRROR.equals(relativePath)) {
            httpRequest.getRequestDispatcher(PATH_PLACEHOLDER_PAGE).forward(request, response);
        } else if (!this.isWhiteListedPath(relativePath)) {
            log.trace("Rejected URL {}.", (Object)relativePath);
            httpResponse.sendRedirect(httpRequest.getContextPath() + PATH_WEB_MIRROR);
        } else {
            log.trace("Passed through URL {}.", (Object)relativePath);
            if (relativePath.startsWith(PATH_WEB_ATST)) {
                request.setAttribute("decorator.override", (Object)"bitbucket.internal.mirror");
            }
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }

    private String getRelativePath(HttpServletRequest request) {
        return request.getRequestURI().substring(request.getContextPath().length());
    }

    private String getUpstreamBaseUrl() {
        UpstreamServer upstream;
        if (this.upstreamBaseUrl == null && (upstream = this.upstreamService.get()) != null) {
            this.upstreamBaseUrl = upstream.getBaseUrl();
        }
        return this.upstreamBaseUrl;
    }

    private boolean isATSTPathAndHasUpstream(String requestPath) {
        return this.getUpstreamBaseUrl() != null && requestPath.startsWith(PATH_WEB_ATST);
    }

    private boolean isWhiteListedPath(String requestPath) {
        return requestPath != null && (this.isStaticResource(requestPath) || requestPath.startsWith(PATH_REST) || requestPath.startsWith("/scm/") || requestPath.startsWith("/git/") || this.isATSTPathAndHasUpstream(requestPath) || PATH_WEB_WHITELIST.contains(requestPath) || PATH_WEB_ERROR.matcher(requestPath).matches());
    }

    private boolean isStaticResource(String requestPath) {
        return this.isBatchResource(requestPath) || this.isUnbatchedResource(requestPath);
    }

    private boolean isUnbatchedResource(String requestPath) {
        return requestPath.startsWith("/download/resources/");
    }

    private boolean isBatchResource(String requestPath) {
        return requestPath.startsWith("/s/") || requestPath.startsWith("/download/contextbatch/");
    }
}

