/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.web;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamServer;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamService;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirroringConfig;
import com.atlassian.bitbucket.internal.mirroring.mirror.nav.MirroringNavBuilder;
import com.atlassian.bitbucket.mirroring.mirror.IntegrationState;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamServer;
import com.atlassian.bitbucket.server.ApplicationMode;
import com.atlassian.bitbucket.server.ApplicationModeSupplier;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.common.collect.ImmutableMap;
import com.google.common.net.MediaType;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

@UnrestrictedAccess
public class MirrorServlet
extends HttpServlet {
    private static final String PARAM_MESSAGE = "error_description";
    private static final String PARAM_REASON = "error";
    private static final String PARAM_RECONNECT = "reconnect";
    private static final String PLACEHOLDER_MODULE_KEY = "com.atlassian.bitbucket.server.bitbucket-mirroring-mirror:mirror-placeholder-page-resources";
    private static final String REASON_ACCESS_DENIED = "access_denied";
    private static final String SOY_ERROR = "error";
    private static final String SOY_MIRROR_STATE = "mirrorState";
    private static final String SOY_MODULE = "moduleKey";
    private static final String SOY_REGISTRATION_URL = "registrationUrl";
    private static final String SOY_RECONNECT_URL = "reconnectUrl";
    private static final String SOY_SERVER_ID = "serverId";
    private static final String SOY_UPSTREAM = "upstream";
    private static final String SOY_UPSTREAM_URL = "upstreamUrl";
    private static final String TEMPLATE_ACTIVE = "bitbucketPluginMirroringMirror.internal.page.placeholder.mirror.active";
    private static final String TEMPLATE_CONNECTING = "bitbucketPluginMirroringMirror.internal.page.placeholder.mirror.connecting";
    private static final String TEMPLATE_PENDING = "bitbucketPluginMirroringMirror.internal.page.placeholder.mirror.pending";
    private static final String TEMPLATE_REMOVED = "bitbucketPluginMirroringMirror.internal.page.placeholder.mirror.removed";
    private static final String TEMPLATE_UNKNOWN = "bitbucketPluginMirroringMirror.internal.page.placeholder.mirror.unknown";
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final MirroringConfig mirroringConfig;
    private final MirroringNavBuilder mirroringNavBuilder;
    private final ApplicationModeSupplier mode;
    private final ApplicationPropertiesService propertiesService;
    private final InternalUpstreamService upstreamService;

    public MirrorServlet(InternalUpstreamService upstreamService, SoyTemplateRenderer soyTemplateRenderer, MirroringConfig mirroringConfig, MirroringNavBuilder mirroringNavBuilder, ApplicationModeSupplier mode, ApplicationPropertiesService propertiesService) {
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.mirroringConfig = mirroringConfig;
        this.mirroringNavBuilder = mirroringNavBuilder;
        this.mode = mode;
        this.propertiesService = propertiesService;
        this.upstreamService = upstreamService;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block14: {
            if (this.mode.getMode() != ApplicationMode.MIRROR) {
                resp.sendError(404);
                return;
            }
            resp.setContentType(MediaType.HTML_UTF_8.toString());
            InternalUpstreamServer upstream = this.upstreamService.get();
            if (upstream == null) {
                this.handleInitialising(resp.getWriter(), Optional.empty());
                return;
            }
            IntegrationState state = upstream.getState();
            if (req.getParameter(PARAM_RECONNECT) != null) {
                this.upstreamService.register();
                String serverId = this.propertiesService.getServerId();
                if (serverId != null && (state == IntegrationState.PENDING || state == IntegrationState.REMOVED || state == IntegrationState.INITIALIZING)) {
                    resp.sendRedirect(this.mirroringNavBuilder.upstream(upstream).authorize(this.mirroringConfig.getMirrorType(), serverId).getAbsolute());
                } else {
                    this.redirectToSelf(resp);
                }
                return;
            }
            if (this.handleSetupParameter(req, resp)) {
                return;
            }
            try {
                if (state == IntegrationState.INITIALIZING) {
                    this.handleInitialising(resp.getWriter(), Optional.of(upstream));
                    break block14;
                }
                if (state == IntegrationState.PENDING) {
                    this.handlePending(req, resp, upstream);
                    break block14;
                }
                if (state == IntegrationState.INSTALLED) {
                    this.handleInstalled(resp, upstream);
                    break block14;
                }
                if (state == IntegrationState.REMOVED) {
                    this.renderRemoved(resp.getWriter(), upstream);
                    break block14;
                }
                if (state == IntegrationState.UNKNOWN) {
                    this.renderPage(resp.getWriter(), upstream, TEMPLATE_UNKNOWN);
                    break block14;
                }
                throw new RuntimeException(String.format("Unexpected upstream state '%s'.", new Object[]{state}));
            }
            catch (SoyException e) {
                Throwable cause = e.getCause();
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                throw new ServletException((Throwable)e);
            }
        }
    }

    private void handleInstalled(HttpServletResponse resp, InternalUpstreamServer upstream) throws IOException {
        this.renderPage(resp.getWriter(), upstream, TEMPLATE_ACTIVE);
    }

    private void handleInitialising(PrintWriter writer, Optional<? extends UpstreamServer> server) {
        ImmutableMap templateContext = new ImmutableMap.Builder().put((Object)SOY_MIRROR_STATE, (Object)IntegrationState.INITIALIZING.getId()).put((Object)SOY_UPSTREAM_URL, (Object)server.map(UpstreamServer::getBaseUrl).orElse("")).put((Object)SOY_UPSTREAM, (Object)server.map(MirrorServlet::getUpstreamHost).orElse("")).build();
        this.soyTemplateRenderer.render((Appendable)writer, "com.atlassian.bitbucket.server.bitbucket-mirroring-mirror:mirror-soy-templates", TEMPLATE_CONNECTING, (Map)templateContext);
    }

    private void handlePending(HttpServletRequest req, HttpServletResponse resp, UpstreamServer upstream) throws IOException {
        this.renderPage(resp.getWriter(), upstream, TEMPLATE_PENDING, MirrorServlet.getErrorFromRequest((ServletRequest)req));
    }

    private boolean handleSetupParameter(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (Boolean.parseBoolean(req.getParameter("setup"))) {
            this.redirectToSelf(resp);
            return true;
        }
        return false;
    }

    private void redirectToSelf(HttpServletResponse resp) throws IOException {
        resp.sendRedirect(this.mirroringNavBuilder.placeholder().getAbsolute());
    }

    private void renderPage(PrintWriter writer, UpstreamServer server, String templateName) {
        this.renderPage(writer, server, templateName, Optional.empty());
    }

    private void renderPage(PrintWriter writer, UpstreamServer server, String templateName, Optional<String> error) {
        String state = server.getState().getId();
        String serverId = Objects.requireNonNull(this.propertiesService.getServerId(), SOY_SERVER_ID);
        String registrationUrl = this.mirroringNavBuilder.upstream(server).authorize(this.mirroringConfig.getMirrorType(), serverId).getAbsolute();
        String upstream = MirrorServlet.getUpstreamHost(server);
        ImmutableMap templateContext = new ImmutableMap.Builder().put((Object)SOY_MIRROR_STATE, (Object)state).put((Object)SOY_REGISTRATION_URL, (Object)registrationUrl).put((Object)SOY_SERVER_ID, (Object)Objects.requireNonNull(serverId)).put((Object)SOY_UPSTREAM_URL, (Object)server.getBaseUrl()).put((Object)SOY_UPSTREAM, (Object)upstream).put((Object)SOY_MODULE, (Object)PLACEHOLDER_MODULE_KEY).put((Object)"error", (Object)error.orElse("")).build();
        this.soyTemplateRenderer.render((Appendable)writer, "com.atlassian.bitbucket.server.bitbucket-mirroring-mirror:mirror-soy-templates", templateName, (Map)templateContext);
    }

    private void renderRemoved(PrintWriter writer, UpstreamServer server) {
        ImmutableMap templateContext = new ImmutableMap.Builder().put((Object)SOY_MIRROR_STATE, (Object)IntegrationState.REMOVED.getId()).put((Object)SOY_UPSTREAM_URL, (Object)server.getBaseUrl()).put((Object)SOY_RECONNECT_URL, (Object)(this.mirroringNavBuilder.placeholder().getAbsolute() + "?reconnect")).put((Object)SOY_MODULE, (Object)PLACEHOLDER_MODULE_KEY).put((Object)SOY_UPSTREAM, (Object)MirrorServlet.getUpstreamHost(server)).build();
        this.soyTemplateRenderer.render((Appendable)writer, "com.atlassian.bitbucket.server.bitbucket-mirroring-mirror:mirror-soy-templates", TEMPLATE_REMOVED, (Map)templateContext);
    }

    private static Optional<String> getErrorFromRequest(ServletRequest request) {
        String reason = StringUtils.stripToNull((String)request.getParameter("error"));
        if (REASON_ACCESS_DENIED.equals(reason)) {
            return Optional.empty();
        }
        return Optional.ofNullable(StringUtils.stripToNull((String)request.getParameter(PARAM_MESSAGE)));
    }

    private static String getUpstreamHost(UpstreamServer server) {
        try {
            String host = StringUtils.stripToNull((String)new URI(server.getBaseUrl()).getHost());
            if (host == null) {
                return server.getBaseUrl();
            }
            return host;
        }
        catch (URISyntaxException e) {
            return server.getBaseUrl();
        }
    }
}

