/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.web;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.bitbucket.cluster.ClusterService;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamServer;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamService;
import com.atlassian.bitbucket.mirroring.mirror.SyncProgress;
import jakarta.annotation.Nonnull;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Locale;

@UnrestrictedAccess
public class StatusRequestInterceptor
implements Filter {
    private final ClusterService clusterService;
    private final InternalUpstreamService upstreamService;

    public StatusRequestInterceptor(ClusterService clusterService, InternalUpstreamService upstreamService) {
        this.clusterService = clusterService;
        this.upstreamService = upstreamService;
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String currentBody;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        OutputInterceptingServletResponse wrapper = new OutputInterceptingServletResponse(httpResponse);
        try {
            chain.doFilter(request, (ServletResponse)wrapper);
            currentBody = wrapper.getOutputBuffer().toString();
        }
        catch (ServletException | IOException | RuntimeException e) {
            response.getWriter().write(wrapper.getOutputBuffer().toString());
            throw e;
        }
        if (currentBody.endsWith("}")) {
            StringBuilder responseBody = new StringBuilder(currentBody.substring(0, currentBody.length() - 1));
            responseBody.append(String.format(", \"memberCount\": \"%s\"", this.clusterService.getInformation().getNodes().size()));
            InternalUpstreamServer internalUpstreamServer = this.upstreamService.get();
            if (internalUpstreamServer != null) {
                SyncProgress progress = this.upstreamService.getSynchronizationProgress(internalUpstreamServer);
                responseBody.append(String.format(", \"discovering\": %s, \"syncedRepos\": %d, \"totalRepos\": %d", progress.getDiscovering(), progress.getSyncedRepos(), progress.getTotalRepos()));
            }
            responseBody.append('}');
            response.getWriter().write(responseBody.toString());
        } else {
            response.getWriter().write(currentBody);
        }
    }

    public void init(FilterConfig filterConfig) {
    }

    static class OutputInterceptingServletResponse
    implements HttpServletResponse {
        private final HttpServletResponse delegate;
        private final ByteArrayOutputStream outputBuffer;
        private final PrintWriter printWriter;

        public OutputInterceptingServletResponse(HttpServletResponse delegate) {
            this.delegate = delegate;
            this.outputBuffer = new ByteArrayOutputStream();
            this.printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)this.outputBuffer, StandardCharsets.UTF_8));
        }

        public void addCookie(Cookie cookie) {
            this.delegate.addCookie(cookie);
        }

        public void addDateHeader(String name, long date) {
            this.delegate.addDateHeader(name, date);
        }

        public void addHeader(String name, String value) {
            this.delegate.addHeader(name, value);
        }

        public void addIntHeader(String name, int value) {
            this.delegate.addIntHeader(name, value);
        }

        public boolean containsHeader(String name) {
            return this.delegate.containsHeader(name);
        }

        public String encodeRedirectURL(String url) {
            return this.delegate.encodeRedirectURL(url);
        }

        public String encodeURL(String url) {
            return this.delegate.encodeURL(url);
        }

        public void flushBuffer() throws IOException {
            this.delegate.flushBuffer();
        }

        public int getBufferSize() {
            return this.delegate.getBufferSize();
        }

        public void setBufferSize(int size) {
            this.delegate.setBufferSize(size);
        }

        public String getCharacterEncoding() {
            return this.delegate.getCharacterEncoding();
        }

        public void setCharacterEncoding(String charset) {
            this.delegate.setCharacterEncoding(charset);
        }

        public String getContentType() {
            return this.delegate.getContentType();
        }

        public void setContentType(String type) {
            this.delegate.setContentType(type);
        }

        public String getHeader(String name) {
            return this.delegate.getHeader(name);
        }

        public Collection<String> getHeaderNames() {
            return this.delegate.getHeaderNames();
        }

        public Collection<String> getHeaders(String name) {
            return this.delegate.getHeaders(name);
        }

        public Locale getLocale() {
            return this.delegate.getLocale();
        }

        public void setLocale(Locale loc) {
            this.delegate.setLocale(loc);
        }

        public ByteArrayOutputStream getOutputBuffer() {
            this.printWriter.flush();
            return this.outputBuffer;
        }

        public ServletOutputStream getOutputStream() throws IOException {
            return new ServletOutputStream(){

                public void close() throws IOException {
                    outputBuffer.close();
                }

                public void flush() throws IOException {
                    outputBuffer.flush();
                }

                public boolean isReady() {
                    return false;
                }

                public void setWriteListener(WriteListener writeListener) {
                }

                public void write(@Nonnull byte[] b) throws IOException {
                    outputBuffer.write(b);
                }

                public void write(int b) {
                    outputBuffer.write(b);
                }

                public void write(@Nonnull byte[] b, int off, int len) {
                    outputBuffer.write(b, off, len);
                }
            };
        }

        public int getStatus() {
            return this.delegate.getStatus();
        }

        public void setStatus(int sc) {
            this.delegate.setStatus(sc);
        }

        public PrintWriter getWriter() {
            return this.printWriter;
        }

        public boolean isCommitted() {
            return this.delegate.isCommitted();
        }

        public void reset() {
            this.delegate.reset();
        }

        public void resetBuffer() {
            this.delegate.resetBuffer();
        }

        public void sendError(int sc, String msg) throws IOException {
            this.delegate.sendError(sc, msg);
        }

        public void sendError(int sc) throws IOException {
            this.delegate.sendError(sc);
        }

        public void sendRedirect(String location) throws IOException {
            this.delegate.sendRedirect(location);
        }

        public void setContentLength(int len) {
            this.delegate.setContentLength(len);
        }

        public void setContentLengthLong(long len) {
            this.delegate.setContentLengthLong(len);
        }

        public void setDateHeader(String name, long date) {
            this.delegate.setDateHeader(name, date);
        }

        public void setHeader(String name, String value) {
            this.delegate.setHeader(name, value);
        }

        public void setIntHeader(String name, int value) {
            this.delegate.setIntHeader(name, value);
        }
    }
}

