/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.webhook;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mirroring.ConstraintViolationUtils;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirroringUserUtils;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.InternalUpstreamRepositoryService;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.MirrorProjectService;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.MirrorRepositoryService;
import com.atlassian.bitbucket.internal.mirroring.mirror.webhook.AbstractWebHookEventVisitor;
import com.atlassian.bitbucket.internal.mirroring.mirror.webhook.MirroredRepositoryFilterVisitor;
import com.atlassian.bitbucket.internal.mirroring.mirror.webhook.MirroringWebHookEvent;
import com.atlassian.bitbucket.internal.mirroring.mirror.webhook.MirroringWebHookEventHandler;
import com.atlassian.bitbucket.internal.mirroring.mirror.webhook.ProjectModifiedWebHookEvent;
import com.atlassian.bitbucket.internal.mirroring.mirror.webhook.RepositoryCreatedWebHookEvent;
import com.atlassian.bitbucket.internal.mirroring.mirror.webhook.RepositoryDefaultBranchModifiedWebHookEvent;
import com.atlassian.bitbucket.internal.mirroring.mirror.webhook.RepositoryDeletedWebHookEvent;
import com.atlassian.bitbucket.internal.mirroring.mirror.webhook.RepositoryModifiedWebHookEvent;
import com.atlassian.bitbucket.internal.mirroring.mirror.webhook.RepositoryRefsChangedWebHookEvent;
import com.atlassian.bitbucket.util.ValidationUtils;
import jakarta.annotation.Nonnull;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultMirroringWebHookEventHandler
implements MirroringWebHookEventHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultMirroringWebHookEventHandler.class);
    private final AuthenticationContext authenticationContext;
    private final I18nService i18nService;
    private final MirrorProjectService mirrorProjectService;
    private final MirrorRepositoryService mirrorRepositoryService;
    private final InternalUpstreamRepositoryService upstreamRepositoryService;
    private final Validator validator;

    @Autowired
    public DefaultMirroringWebHookEventHandler(AuthenticationContext authenticationContext, I18nService i18nService, MirrorProjectService mirrorProjectService, MirrorRepositoryService mirrorRepositoryService, InternalUpstreamRepositoryService upstreamRepositoryService, Validator validator) {
        this.authenticationContext = authenticationContext;
        this.i18nService = i18nService;
        this.mirrorProjectService = mirrorProjectService;
        this.mirrorRepositoryService = mirrorRepositoryService;
        this.upstreamRepositoryService = upstreamRepositoryService;
        this.validator = validator;
    }

    @Override
    public void handleEvent(@Nonnull String upstreamId, @Nonnull MirroringWebHookEvent event) {
        this.validate(event);
        this.validateAuthenticatedAsUpstream(upstreamId);
        log.trace("Handling {} event from upstream {}", event.getClass(), (Object)upstreamId);
        event.visit(new MirroredRepositoryFilterVisitor(new AbstractWebHookEventVisitor(){

            @Override
            public void accept(ProjectModifiedWebHookEvent event) {
                DefaultMirroringWebHookEventHandler.this.upstreamRepositoryService.onProjectModified(event.getProject());
            }

            @Override
            public void accept(RepositoryCreatedWebHookEvent event) {
                DefaultMirroringWebHookEventHandler.this.upstreamRepositoryService.onRepositoryCreated(event.getRepository());
            }

            @Override
            public void accept(RepositoryDefaultBranchModifiedWebHookEvent event) {
                DefaultMirroringWebHookEventHandler.this.upstreamRepositoryService.onRepositoryDefaultBranchModified(event.getRepository(), event.getNewValue());
            }

            @Override
            public void accept(RepositoryDeletedWebHookEvent event) {
                DefaultMirroringWebHookEventHandler.this.upstreamRepositoryService.onRepositoryDeleted(event.getRepository());
            }

            @Override
            public void accept(RepositoryModifiedWebHookEvent event) {
                DefaultMirroringWebHookEventHandler.this.upstreamRepositoryService.onRepositoryModified(event.getRepository());
            }

            @Override
            public void accept(RepositoryRefsChangedWebHookEvent event) {
                DefaultMirroringWebHookEventHandler.this.upstreamRepositoryService.onRepositoryContentsChanged(event.getRepository(), event.getChanges());
            }
        }, this.mirrorProjectService, this.mirrorRepositoryService));
    }

    private boolean isAuthenticatedAsUpstream(String upstreamId) {
        return MirroringUserUtils.isUpstreamUserFor(this.authenticationContext.getCurrentUser(), upstreamId);
    }

    private void validate(@Nonnull MirroringWebHookEvent event) {
        try {
            ValidationUtils.validate((Validator)this.validator, (Object)event, (Class[])new Class[0]);
        }
        catch (ConstraintViolationException e) {
            String constraintsMessage = ConstraintViolationUtils.violationToString(e);
            log.info("Web hook had an unexpected format - ignoring: {}. Error details:", (Object)constraintsMessage, (Object)e);
            throw e;
        }
    }

    private void validateAuthenticatedAsUpstream(String upstreamId) {
        if (!this.isAuthenticatedAsUpstream(upstreamId)) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.mirroring.operation.not.permitted", new Object[0]));
        }
    }
}

