/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.webhook;

import com.atlassian.bitbucket.internal.mirroring.mirror.repository.MirrorProjectService;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.MirrorRepositoryService;
import com.atlassian.bitbucket.internal.mirroring.mirror.webhook.ProjectCreatedWebHookEvent;
import com.atlassian.bitbucket.internal.mirroring.mirror.webhook.ProjectDeletedWebHookEvent;
import com.atlassian.bitbucket.internal.mirroring.mirror.webhook.ProjectModifiedWebHookEvent;
import com.atlassian.bitbucket.internal.mirroring.mirror.webhook.RepositoryCreatedWebHookEvent;
import com.atlassian.bitbucket.internal.mirroring.mirror.webhook.RepositoryDefaultBranchModifiedWebHookEvent;
import com.atlassian.bitbucket.internal.mirroring.mirror.webhook.RepositoryDeletedWebHookEvent;
import com.atlassian.bitbucket.internal.mirroring.mirror.webhook.RepositoryModifiedWebHookEvent;
import com.atlassian.bitbucket.internal.mirroring.mirror.webhook.RepositoryRefsChangedWebHookEvent;
import com.atlassian.bitbucket.internal.mirroring.mirror.webhook.WebHookEventVisitor;
import jakarta.annotation.Nonnull;
import java.util.Objects;

class MirroredRepositoryFilterVisitor
implements WebHookEventVisitor {
    private WebHookEventVisitor delegate;
    private MirrorProjectService mirrorProjectService;
    private MirrorRepositoryService mirrorRepositoryService;

    MirroredRepositoryFilterVisitor(@Nonnull WebHookEventVisitor delegate, @Nonnull MirrorProjectService mirrorProjectService, @Nonnull MirrorRepositoryService mirrorRepositoryService) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        this.mirrorProjectService = Objects.requireNonNull(mirrorProjectService, "mirrorProjectService");
        this.mirrorRepositoryService = Objects.requireNonNull(mirrorRepositoryService, "mirrorRepositoryService");
    }

    @Override
    public void accept(ProjectCreatedWebHookEvent event) {
        this.delegate.accept(event);
    }

    @Override
    public void accept(ProjectDeletedWebHookEvent event) {
        this.delegate.accept(event);
    }

    @Override
    public void accept(ProjectModifiedWebHookEvent event) {
        this.delegate.accept(event);
    }

    @Override
    public void accept(RepositoryCreatedWebHookEvent event) {
        if (this.mirrorRepositoryService.isMirrored(event.getRepository())) {
            this.delegate.accept(event);
        }
    }

    @Override
    public void accept(RepositoryDefaultBranchModifiedWebHookEvent event) {
        if (this.mirrorRepositoryService.isMirrored(event.getRepository())) {
            this.delegate.accept(event);
        }
    }

    @Override
    public void accept(RepositoryDeletedWebHookEvent event) {
        if (this.mirrorRepositoryService.isMirrored(event.getRepository())) {
            this.delegate.accept(event);
        }
    }

    @Override
    public void accept(RepositoryModifiedWebHookEvent event) {
        block3: {
            block2: {
                if (this.mirrorRepositoryService.isMirrored(event.getRepository())) break block2;
                if (!event.getOldProject().map(this.mirrorProjectService::isMirrored).orElse(false).booleanValue()) break block3;
            }
            this.delegate.accept(event);
        }
    }

    @Override
    public void accept(RepositoryRefsChangedWebHookEvent event) {
        if (this.mirrorRepositoryService.isMirrored(event.getRepository())) {
            this.delegate.accept(event);
        }
    }
}

