/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.rest;

import com.atlassian.bitbucket.internal.mirroring.MirrorUpgradeRequest;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;

@JsonSerialize
public class RestMirrorUpgradeRequest
extends RestMapEntity {
    private static final String BASE_URL = "baseUrl";
    private static final String PRODUCT_VERSION = "productVersion";

    public RestMirrorUpgradeRequest() {
    }

    public RestMirrorUpgradeRequest(MirrorUpgradeRequest upgradeRequest) {
        this.put(BASE_URL, upgradeRequest.getBaseUrl());
        this.put(PRODUCT_VERSION, upgradeRequest.getProductVersion());
    }

    @Schema(example="https://bitbucket-eu.example.com:7990/bitbucket")
    @RequiredString(size=450)
    public String getBaseUrl() {
        return this.getStringProperty(BASE_URL);
    }

    @Schema(example="8.0.0")
    @RequiredString(size=64)
    public String getProductVersion() {
        return this.getStringProperty(PRODUCT_VERSION);
    }
}

