/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.rest;

import com.atlassian.bitbucket.internal.mirroring.rest.RestMirrorEventType;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import java.util.Map;

@JsonSerialize
public class RestRepositoryMirrorEvent
extends RestMapEntity {
    private static final String MIRROR_REPO_ID = "mirrorRepoId";
    private static final String TYPE = "type";
    private static final String UPSTREAM_REPO_ID = "upstreamRepoId";

    public RestRepositoryMirrorEvent() {
    }

    public RestRepositoryMirrorEvent(Map<String, ?> values) {
        super(values);
    }

    RestRepositoryMirrorEvent(int mirrorRepoId, RestMirrorEventType eventType, @Nonnull String upstreamRepoId) {
        this.put(MIRROR_REPO_ID, mirrorRepoId);
        this.put(TYPE, (Object)eventType);
        this.put(UPSTREAM_REPO_ID, upstreamRepoId);
    }

    @Schema(example="42")
    public int getMirrorRepoId() {
        return this.getIntProperty(MIRROR_REPO_ID);
    }

    @Nonnull
    public RestMirrorEventType getType() {
        return (RestMirrorEventType)this.getEnumProperty(TYPE, RestMirrorEventType.class);
    }

    @Schema(example="24")
    @Nonnull
    public String getUpstreamRepoId() {
        return this.getStringProperty(UPSTREAM_REPO_ID);
    }
}

