/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.rest;

import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.ssh.SshKeyFingerprint;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Objects;

public class RestUpstreamSshKeyFingerprint
extends RestMapEntity {
    private static final String ALGORITHM = "algorithm";
    private static final String VALUE = "value";

    public RestUpstreamSshKeyFingerprint() {
    }

    public RestUpstreamSshKeyFingerprint(SshKeyFingerprint fingerprint) {
        Objects.requireNonNull(fingerprint, "fingerprint");
        this.put(ALGORITHM, Objects.requireNonNull(fingerprint.getAlgorithm(), ALGORITHM));
        this.put(VALUE, Objects.requireNonNull(fingerprint.getValue(), ALGORITHM));
    }

    public RestUpstreamSshKeyFingerprint(Map fingerprint) {
        Objects.requireNonNull(fingerprint, "fingerprint");
        this.put(ALGORITHM, Objects.requireNonNull(fingerprint.get(ALGORITHM), ALGORITHM));
        this.put(VALUE, Objects.requireNonNull(fingerprint.get(VALUE), ALGORITHM));
    }

    public static RestUpstreamSshKeyFingerprint valueOf(Object value) {
        if (value instanceof RestUpstreamSshKeyFingerprint) {
            return (RestUpstreamSshKeyFingerprint)((Object)value);
        }
        if (value instanceof Map) {
            return new RestUpstreamSshKeyFingerprint((Map)value);
        }
        return null;
    }

    @Schema(example="RSA")
    @Nonnull
    public String getAlgorithm() {
        return this.getStringProperty(ALGORITHM);
    }

    @Schema(example="1BE9A09D47279BF92501DEB9A3D8717D")
    @Nonnull
    public String getValue() {
        return this.getStringProperty(VALUE);
    }
}

