/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.rest;

import com.atlassian.bitbucket.internal.mirroring.rest.RestUpstreamSshKeyFingerprint;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.ssh.SimpleSshKeyFingerprint;
import com.atlassian.bitbucket.ssh.SshKeyFingerprint;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonSerialize
public class RestUpstreamSshSettings
extends RestMapEntity {
    private static final String ACCESS_KEYS = "accessKeys";
    private static final String BASE_URL = "baseUrl";
    private static final String ENABLED = "enabled";
    private static final String FINGERPRINT = "fingerprint";
    private static final String PORT = "port";

    public RestUpstreamSshSettings() {
    }

    public RestUpstreamSshSettings(boolean accessKeysEnabled, @Nonnull String baseUrl, boolean enabled, @Nonnull SshKeyFingerprint fingerprint, int port) {
        this.put(ACCESS_KEYS, ImmutableMap.of((Object)ENABLED, (Object)accessKeysEnabled));
        this.put(BASE_URL, Objects.requireNonNull(baseUrl, BASE_URL));
        this.put(ENABLED, enabled);
        this.put(FINGERPRINT, (Object)new RestUpstreamSshKeyFingerprint(Objects.requireNonNull(fingerprint, FINGERPRINT)));
        this.put(PORT, port);
    }

    @Nonnull
    public String getBaseUrl() {
        return this.getStringProperty(BASE_URL);
    }

    @Nonnull
    public SshKeyFingerprint getFingerprint() {
        RestUpstreamSshKeyFingerprint fingerprint = RestUpstreamSshKeyFingerprint.valueOf(this.get(FINGERPRINT));
        if (fingerprint == null) {
            return null;
        }
        return new SimpleSshKeyFingerprint(fingerprint.getAlgorithm(), fingerprint.getValue());
    }

    public int getPort() {
        return this.getIntProperty(PORT);
    }

    public boolean isAccessKeysEnabled() {
        return Optional.ofNullable(this.get(ACCESS_KEYS)).flatMap(accessKeys -> Optional.ofNullable((Boolean)((Map)accessKeys).get(ENABLED))).orElse(false);
    }

    public boolean isEnabled() {
        return this.getBoolProperty(ENABLED);
    }
}

