/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.rest.auth;

import com.atlassian.bitbucket.dmz.permission.AbstractEffectivePermissionVisitor;
import com.atlassian.bitbucket.dmz.permission.EffectiveGlobalPermission;
import com.atlassian.bitbucket.dmz.permission.EffectivePermission;
import com.atlassian.bitbucket.dmz.permission.EffectivePermissionVisitor;
import com.atlassian.bitbucket.dmz.permission.EffectiveProjectPermission;
import com.atlassian.bitbucket.dmz.permission.EffectiveRepositoryPermission;
import com.atlassian.bitbucket.internal.mirroring.rest.permission.RestEffectiveGlobalPermission;
import com.atlassian.bitbucket.internal.mirroring.rest.permission.RestEffectivePermission;
import com.atlassian.bitbucket.internal.mirroring.rest.permission.RestEffectiveProjectPermission;
import com.atlassian.bitbucket.internal.mirroring.rest.permission.RestEffectiveRepositoryPermission;
import com.atlassian.bitbucket.internal.mirroring.user.ApplicationUserWithPermissions;
import com.atlassian.bitbucket.internal.mirroring.user.ApplicationUserWithPermissionsVisitor;
import com.atlassian.bitbucket.rest.v2.api.user.RestApplicationUser;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.ApplicationUserVisitor;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import jakarta.annotation.Nonnull;
import java.util.Collections;

public class RestApplicationUserWithPermissions
extends RestApplicationUser
implements ApplicationUserWithPermissions {
    public static final Function<Object, EffectivePermission> TO_EFFECTIVE_PERMISSION = input -> {
        if (input instanceof EffectivePermission) {
            return (EffectivePermission)input;
        }
        RestEffectivePermission effectivePerm = RestEffectiveProjectPermission.valueOf(input);
        if (effectivePerm == null) {
            effectivePerm = RestEffectiveRepositoryPermission.valueOf(input);
        }
        if (effectivePerm == null) {
            effectivePerm = RestEffectiveGlobalPermission.valueOf(input);
        }
        return effectivePerm;
    };

    public RestApplicationUserWithPermissions() {
    }

    public RestApplicationUserWithPermissions(ApplicationUserWithPermissions user) {
        super((ApplicationUser)user);
        this.put("effectivePermissions", Lists.newLinkedList((Iterable)Iterables.transform(user.getEffectivePermissions(), permission -> permission.accept((EffectivePermissionVisitor)new AbstractEffectivePermissionVisitor<Object>(this){

            public Object visit(@Nonnull EffectiveGlobalPermission permission) {
                return new RestEffectiveGlobalPermission(permission);
            }

            public Object visit(@Nonnull EffectiveProjectPermission permission) {
                return new RestEffectiveProjectPermission(permission);
            }

            public Object visit(@Nonnull EffectiveRepositoryPermission permission) {
                return new RestEffectiveRepositoryPermission(permission);
            }
        }))));
    }

    @Override
    @Nonnull
    public Iterable<EffectivePermission> getEffectivePermissions() {
        Iterable effectivePermissions = (Iterable)this.get("effectivePermissions");
        if (effectivePermissions == null) {
            return Collections.emptyList();
        }
        return Lists.newArrayList((Iterable)Iterables.filter((Iterable)Iterables.transform((Iterable)effectivePermissions, TO_EFFECTIVE_PERMISSION), (Predicate)Predicates.notNull()));
    }

    public <T> T accept(@Nonnull ApplicationUserVisitor<T> visitor) {
        if (visitor instanceof ApplicationUserWithPermissionsVisitor) {
            return ((ApplicationUserWithPermissionsVisitor)visitor).visit(this);
        }
        return (T)super.accept(visitor);
    }
}

