/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.ssh.encoding;

import com.atlassian.bitbucket.dmz.ssh.DmzPublicKeyCodec;
import com.atlassian.bitbucket.internal.mirroring.ssh.encoding.PublicKeyEncodingHelper;
import jakarta.annotation.Nonnull;
import java.security.PublicKey;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class DefaultPublicKeyEncodingHelper
implements PublicKeyEncodingHelper {
    private final DmzPublicKeyCodec publicKeyCodec;

    public DefaultPublicKeyEncodingHelper(DmzPublicKeyCodec publicKeyCodec) {
        this.publicKeyCodec = publicKeyCodec;
    }

    @Override
    @Nonnull
    public String encodeAsOpenSsh(@Nonnull PublicKey key) {
        return this.encodeAsOpenSsh(key, "");
    }

    @Override
    @Nonnull
    public String encodeAsOpenSsh(@Nonnull PublicKey key, @Nonnull String label) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(label, "label");
        String keyText = this.publicKeyCodec.encode(key);
        return StringUtils.trim((String)(keyText + " " + label));
    }
}

