/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.mirroring;

import com.atlassian.bitbucket.mirroring.MirroringFeature;
import com.atlassian.bitbucket.mirroring.MirroringRole;
import com.atlassian.bitbucket.mirroring.RepositoryListMode;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Set;

public class MirroringCapabilities {
    private final Set<MirroringFeature> features;
    private final Set<RepositoryListMode> repositoryListModes;
    private final Set<MirroringRole> roles;

    private MirroringCapabilities(Builder builder) {
        this.features = builder.features.build();
        this.repositoryListModes = builder.repositoryListModes.build();
        this.roles = builder.roles.build();
    }

    @Nonnull
    public Set<MirroringFeature> getFeatures() {
        return this.features;
    }

    @Nonnull
    public Set<RepositoryListMode> getRepositoryListModes() {
        return this.repositoryListModes;
    }

    @Nonnull
    public Set<MirroringRole> getRoles() {
        return this.roles;
    }

    public static class Builder
    extends BuilderSupport {
        private final ImmutableSet.Builder<MirroringFeature> features = ImmutableSet.builder();
        private final ImmutableSet.Builder<RepositoryListMode> repositoryListModes = ImmutableSet.builder();
        private final ImmutableSet.Builder<MirroringRole> roles = ImmutableSet.builder();

        @Nonnull
        public MirroringCapabilities build() {
            return new MirroringCapabilities(this);
        }

        @Nonnull
        public Builder features(@Nullable Iterable<MirroringFeature> values) {
            Builder.addIf(Objects::nonNull, this.features, values);
            return this;
        }

        @Nonnull
        public Builder repositoryListModes(@Nullable Iterable<RepositoryListMode> values) {
            Builder.addIf(Objects::nonNull, this.repositoryListModes, values);
            return this;
        }

        @Nonnull
        public Builder roles(@Nullable Iterable<MirroringRole> values) {
            Builder.addIf(Objects::nonNull, this.roles, values);
            return this;
        }
    }
}

