/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.mirroring;

import jakarta.annotation.Nonnull;
import java.util.Optional;

public enum MirroringFeature {
    CONNECT_REMOVED("connect_removed"),
    FARM("farm"),
    REPOSITORY_CONTENT_HASH_REFRESH("repo_content_hash_refresh", false);

    private final String id;
    private final boolean mandatory;

    private MirroringFeature(String id) {
        this(id, true);
    }

    private MirroringFeature(String id, boolean mandatory) {
        this.id = id;
        this.mandatory = mandatory;
    }

    @Nonnull
    public static Optional<MirroringFeature> fromId(String id) {
        for (MirroringFeature value : MirroringFeature.values()) {
            if (!value.getId().equalsIgnoreCase(id)) continue;
            return Optional.of(value);
        }
        return Optional.empty();
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public String toString() {
        return this.id;
    }
}

