/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.mirroring;

import jakarta.annotation.Nonnull;
import java.util.Optional;

public enum RepositoryListMode {
    ALL("all"),
    BY_ID("by-id"),
    BY_PROJECT("by-project");

    private final String id;

    private RepositoryListMode(String id) {
        this.id = id;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    @Nonnull
    public static Optional<RepositoryListMode> fromId(String id) {
        for (RepositoryListMode value : RepositoryListMode.values()) {
            if (!value.getId().equalsIgnoreCase(id)) continue;
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public String toString() {
        return this.id;
    }
}

