/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.mirroring.mirror;

import com.atlassian.bitbucket.event.repository.RepositoryEvent;
import com.atlassian.bitbucket.repository.Repository;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

public class AbstractRetryableUpstreamRepositoryEvent
extends RepositoryEvent {
    private final AtomicInteger attempt = new AtomicInteger(1);
    private final String externalRepositoryId;

    public AbstractRetryableUpstreamRepositoryEvent(@Nonnull Object source, @Nonnull Repository repository, @Nonnull String externalRepositoryId) {
        super(source, repository);
        this.externalRepositoryId = Objects.requireNonNull(externalRepositoryId, "externalRepositoryId");
    }

    public int getAttempt() {
        return this.attempt.get();
    }

    @Nonnull
    public String getExternalRepositoryId() {
        return this.externalRepositoryId;
    }

    public void incrementAttempts() {
        this.attempt.incrementAndGet();
    }
}

