/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.mirroring.mirror;

import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamServer;
import com.atlassian.event.api.AsynchronousPreferred;
import jakarta.annotation.Nonnull;
import java.util.Date;
import java.util.Objects;
import java.util.Set;

@TransactionAware
@AsynchronousPreferred
public class FullSynchronizationEvent
extends ApplicationEvent {
    private final Date startDate;
    private final Set<String> syncedExternalProjectIds;
    private final UpstreamServer upstream;

    public FullSynchronizationEvent(@Nonnull Object source, @Nonnull Date startDate, @Nonnull UpstreamServer upstream, @Nonnull Set<String> syncedExternalProjectIds) {
        super(source);
        this.syncedExternalProjectIds = syncedExternalProjectIds;
        this.startDate = Objects.requireNonNull(startDate, "startDate");
        this.upstream = Objects.requireNonNull(upstream, "upstream");
    }

    @Nonnull
    public Set<String> getSyncedExternalProjectIds() {
        return this.syncedExternalProjectIds;
    }

    @Nonnull
    public Date getStartDate() {
        return this.startDate;
    }

    @Nonnull
    public UpstreamServer getUpstream() {
        return this.upstream;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        FullSynchronizationEvent that = (FullSynchronizationEvent)((Object)o);
        return Objects.equals(this.startDate, that.startDate) && Objects.equals(this.syncedExternalProjectIds, that.syncedExternalProjectIds) && Objects.equals(this.upstream, that.upstream);
    }

    public int hashCode() {
        return Objects.hash(this.startDate, this.syncedExternalProjectIds, this.upstream);
    }
}

