/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.mirroring.mirror;

import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.event.api.AsynchronousPreferred;
import jakarta.annotation.Nonnull;
import java.util.Objects;

@AsynchronousPreferred
public class ProjectSynchronizedEvent
extends ApplicationEvent {
    private final String externalProjectId;
    private final String upstreamServerId;

    public ProjectSynchronizedEvent(@Nonnull Object source, @Nonnull String externalProjectId, @Nonnull String upstreamServerId) {
        super(source);
        this.externalProjectId = Objects.requireNonNull(externalProjectId, "externalProjectId");
        this.upstreamServerId = Objects.requireNonNull(upstreamServerId, "upstreamServerId");
    }

    @Nonnull
    public String getUpstreamServerId() {
        return this.upstreamServerId;
    }

    @Nonnull
    public String getExternalProjectId() {
        return this.externalProjectId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ProjectSynchronizedEvent that = (ProjectSynchronizedEvent)((Object)o);
        return Objects.equals(this.externalProjectId, that.externalProjectId) && Objects.equals(this.upstreamServerId, that.upstreamServerId);
    }

    public int hashCode() {
        return Objects.hash(this.externalProjectId, this.upstreamServerId);
    }
}

