/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.mirroring.mirror;

import com.atlassian.bitbucket.mirroring.mirror.AbstractRetryableUpstreamRepositoryEvent;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.mirror.RepositorySynchronizationType;
import com.atlassian.bitbucket.util.NamedLink;
import com.atlassian.event.api.AsynchronousPreferred;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Objects;

@AsynchronousPreferred
public class RepositorySynchronizedOnFarmEvent
extends AbstractRetryableUpstreamRepositoryEvent {
    private final Collection<NamedLink> cloneLinks;
    private final Collection<RefChange> refChanges;
    private final boolean refLimitExceeded;
    private final RepositorySynchronizationType syncType;

    private RepositorySynchronizedOnFarmEvent(Builder builder) {
        super(builder.source, builder.repository, builder.externalRepositoryId);
        this.cloneLinks = builder.cloneLinks;
        this.refChanges = builder.refChanges;
        this.refLimitExceeded = builder.refLimitExceeded;
        this.syncType = builder.syncType;
    }

    @Nonnull
    public Collection<NamedLink> getCloneLinks() {
        return this.cloneLinks;
    }

    @Nonnull
    public Collection<RefChange> getRefChanges() {
        return this.refChanges;
    }

    @Nonnull
    public RepositorySynchronizationType getSyncType() {
        return this.syncType;
    }

    public boolean isRefLimitExceeded() {
        return this.refLimitExceeded;
    }

    public static class Builder {
        private final Repository repository;
        private final Object source;
        private Collection<NamedLink> cloneLinks;
        private String externalRepositoryId;
        private Collection<RefChange> refChanges;
        private boolean refLimitExceeded;
        private RepositorySynchronizationType syncType;

        public Builder(@Nonnull Object source, @Nonnull Repository repository) {
            this.cloneLinks = ImmutableList.of();
            this.refLimitExceeded = false;
            this.repository = Objects.requireNonNull(repository, "repository");
            this.source = Objects.requireNonNull(source, "source");
            this.syncType = RepositorySynchronizationType.SNAPSHOT;
        }

        public Builder(@Nonnull RepositorySynchronizedOnFarmEvent event) {
            Objects.requireNonNull(event, "event");
            this.cloneLinks = ImmutableList.copyOf(event.getCloneLinks());
            this.externalRepositoryId = event.getExternalRepositoryId();
            this.refChanges = ImmutableList.copyOf(event.refChanges);
            this.refLimitExceeded = event.refLimitExceeded;
            this.repository = event.getRepository();
            this.source = event.source;
            this.syncType = event.getSyncType();
        }

        @Nonnull
        public RepositorySynchronizedOnFarmEvent build() {
            this.validate();
            return new RepositorySynchronizedOnFarmEvent(this);
        }

        @Nonnull
        public Builder cloneLinks(@Nonnull Collection<NamedLink> cloneLinks) {
            this.cloneLinks = Objects.requireNonNull(cloneLinks, "cloneLinks");
            return this;
        }

        public Builder externalRepositoryId(@Nonnull String externalRepositoryId) {
            this.externalRepositoryId = Objects.requireNonNull(externalRepositoryId, "externalRepositoryId");
            return this;
        }

        @Nonnull
        public Builder refChanges(@Nonnull Collection<RefChange> refChanges) {
            this.refChanges = Objects.requireNonNull(refChanges, "refChanges");
            return this;
        }

        @Nonnull
        public Builder refLimitExceeded(boolean refLimitExceeded) {
            this.refLimitExceeded = refLimitExceeded;
            return this;
        }

        @Nonnull
        public Builder syncType(@Nonnull RepositorySynchronizationType syncType) {
            this.syncType = Objects.requireNonNull(syncType, "syncType");
            return this;
        }

        private void validate() {
            if (this.cloneLinks == null) {
                throw new IllegalArgumentException("cloneLinks not supplied!");
            }
            if (this.externalRepositoryId == null) {
                throw new IllegalArgumentException("externalRepositoryId not supplied!");
            }
            if (this.syncType == null) {
                throw new IllegalArgumentException("syncType not supplied!");
            }
            if (this.refChanges == null) {
                throw new IllegalArgumentException("refChanges not supplied!");
            }
        }
    }
}

