/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.mirroring.mirror;

import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamServer;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamSettings;
import com.atlassian.event.api.AsynchronousPreferred;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

@TransactionAware
@AsynchronousPreferred
public class UpstreamSettingsChangedEvent
extends ApplicationEvent {
    private final UpstreamServer upstream;
    private final UpstreamSettings oldSettings;
    private final UpstreamSettings newSettings;

    public UpstreamSettingsChangedEvent(@Nonnull Object source, @Nonnull UpstreamServer upstream, @Nullable UpstreamSettings oldSettings, @Nonnull UpstreamSettings newSettings) {
        super(source);
        this.newSettings = Objects.requireNonNull(newSettings, "newSettings");
        this.oldSettings = oldSettings;
        this.upstream = Objects.requireNonNull(upstream, "upstream");
    }

    @Nonnull
    public UpstreamSettings getNewSettings() {
        return this.newSettings;
    }

    @Nullable
    public UpstreamSettings getOldSettings() {
        return this.oldSettings;
    }

    @Nonnull
    public UpstreamServer getUpstream() {
        return this.upstream;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("upstream", (Object)this.upstream).add("oldSettings", (Object)this.oldSettings).add("newSettings", (Object)this.newSettings).add("source", this.source).toString();
    }
}

