/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.mirroring.mirror;

import com.atlassian.bitbucket.mirroring.mirror.MirroringMode;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamSettingsRequest;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;

public class UpstreamSettingsSetRequest
implements UpstreamSettingsRequest {
    private static final long serialVersionUID = -8422037417223502708L;
    private final String upstreamId;
    private final MirroringMode mode;
    private final List<String> projectIds;

    private UpstreamSettingsSetRequest(Builder builder) {
        this.upstreamId = builder.upstreamId;
        this.mode = builder.mode;
        this.projectIds = builder.projectIds.build();
    }

    @Override
    @Nonnull
    public String getUpstreamId() {
        return this.upstreamId;
    }

    @Nonnull
    public MirroringMode getMode() {
        return this.mode;
    }

    @Nonnull
    public List<String> getProjectIds() {
        return this.projectIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpstreamSettingsSetRequest that = (UpstreamSettingsSetRequest)o;
        return Objects.equals(this.upstreamId, that.upstreamId) && this.mode == that.mode && Objects.equals(this.projectIds, that.projectIds);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.upstreamId, this.mode, this.projectIds});
    }

    public String toString() {
        return "UpstreamSettingsSetRequest{upstreamId='" + this.upstreamId + "', mode=" + String.valueOf((Object)this.mode) + ", projectIds=" + String.valueOf(this.projectIds) + "}";
    }

    public static class Builder {
        private final ImmutableList.Builder<String> projectIds;
        private String upstreamId;
        private MirroringMode mode;

        public Builder(@Nonnull String upstreamId) {
            this.upstreamId = Objects.requireNonNull(upstreamId, "mirrorId");
            this.mode = MirroringMode.ALL_PROJECTS;
            this.projectIds = ImmutableList.builder();
        }

        @Nonnull
        public UpstreamSettingsSetRequest build() {
            return new UpstreamSettingsSetRequest(this);
        }

        @Nonnull
        public Builder upstreamId(@Nonnull String value) {
            this.upstreamId = Objects.requireNonNull(value, "upstreamId");
            return this;
        }

        @Nonnull
        public Builder mode(@Nonnull MirroringMode value) {
            this.mode = Objects.requireNonNull(value, "mode");
            return this;
        }

        @Nonnull
        public Builder projectIds(@Nonnull String externalId, String ... moreExternalIds) {
            this.projectIds.add((Object)Objects.requireNonNull(externalId, "externalId"));
            for (String id : Objects.requireNonNull(moreExternalIds, "moreExternalIds")) {
                this.projectIds.add((Object)Objects.requireNonNull(id, "exterrnalId"));
            }
            return this;
        }

        @Nonnull
        public Builder projectIds(@Nonnull Iterable<String> externalIds) {
            for (String id : Objects.requireNonNull(externalIds, "externalIds")) {
                this.projectIds.add((Object)Objects.requireNonNull(id, "externalId"));
            }
            return this;
        }
    }
}

