/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.mirroring.mirror;

import com.atlassian.bitbucket.mirroring.mirror.MirroringMode;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamSettingsRequest;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;

public class UpstreamSettingsUpdateRequest
implements UpstreamSettingsRequest {
    private static final long serialVersionUID = -2797968914891210282L;
    private final List<String> addedProjects;
    private final MirroringMode mode;
    private final List<String> removedProjects;
    private final String upstreamId;

    private UpstreamSettingsUpdateRequest(Builder builder) {
        this.addedProjects = builder.addedProjectsBuilder.build();
        this.mode = builder.mode;
        this.removedProjects = builder.removeProjectsBuilder.build();
        this.upstreamId = builder.upstreamId;
    }

    @Nonnull
    public List<String> getAddedProjects() {
        return this.addedProjects;
    }

    @Nullable
    public MirroringMode getMode() {
        return this.mode;
    }

    @Nonnull
    public List<String> getRemovedProjects() {
        return this.removedProjects;
    }

    @Override
    @Nonnull
    public String getUpstreamId() {
        return this.upstreamId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpstreamSettingsUpdateRequest that = (UpstreamSettingsUpdateRequest)o;
        return Objects.equals(this.addedProjects, that.addedProjects) && this.mode == that.mode && Objects.equals(this.removedProjects, that.removedProjects) && Objects.equals(this.upstreamId, that.upstreamId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.addedProjects, this.mode, this.removedProjects, this.upstreamId});
    }

    public String toString() {
        return "UpstreamSettingsUpdateRequest{addedProjects=" + String.valueOf(this.addedProjects) + ", mode=" + String.valueOf((Object)this.mode) + ", removedProjects=" + String.valueOf(this.removedProjects) + ", upstreamId='" + this.upstreamId + "'}";
    }

    public static class Builder
    extends BuilderSupport {
        private ImmutableList.Builder<String> addedProjectsBuilder = ImmutableList.builder();
        private MirroringMode mode;
        private ImmutableList.Builder<String> removeProjectsBuilder = ImmutableList.builder();
        private final String upstreamId;

        public Builder(@Nonnull String upstreamId) {
            this.upstreamId = Objects.requireNonNull(upstreamId, "upstreamId");
        }

        @Nonnull
        public Builder addProjects(@Nonnull String externalId, String ... moreExternalIds) {
            return this.addToBuilder(this.addedProjectsBuilder, externalId, moreExternalIds);
        }

        @Nonnull
        public Builder addProjects(@Nonnull Iterable<String> ids) {
            return this.addToBuilder(this.addedProjectsBuilder, ids);
        }

        @Nonnull
        public UpstreamSettingsUpdateRequest build() {
            return new UpstreamSettingsUpdateRequest(this);
        }

        @Nonnull
        public Builder mode(@Nullable MirroringMode value) {
            this.mode = value;
            return this;
        }

        @Nonnull
        public Builder removeProjects(@Nonnull String externalId, String ... moreExternalIds) {
            return this.addToBuilder(this.removeProjectsBuilder, externalId, moreExternalIds);
        }

        @Nonnull
        public Builder removeProjects(@Nonnull Iterable<String> ids) {
            return this.addToBuilder(this.removeProjectsBuilder, ids);
        }

        private Builder addToBuilder(ImmutableList.Builder<String> builder, @Nonnull String externalId, String ... moreExternalIds) {
            builder.add((Object)Objects.requireNonNull(externalId, "externalId"));
            for (String id : moreExternalIds) {
                builder.add((Object)Objects.requireNonNull(id, "externalId"));
            }
            return this;
        }

        private Builder addToBuilder(ImmutableList.Builder<String> builder, @Nonnull Iterable<String> ids) {
            for (String id : Objects.requireNonNull(ids, "ids")) {
                builder.add((Object)id);
            }
            return this;
        }
    }
}

