/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.mirroring.mirror;

import com.atlassian.bitbucket.internal.mirroring.mirror.SimpleUpstreamSettings;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.AoMirroredProject;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.AoUpstreamSettings;
import com.atlassian.bitbucket.mirroring.mirror.MirroringMode;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamSettings;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;

public class UpstreamSettingsUtils {
    public static Set<String> getMirroredProjectIds(AoUpstreamSettings settings) {
        Object[] mirroredProjects = settings.getMirroredProjects();
        if (ArrayUtils.isNotEmpty((Object[])mirroredProjects)) {
            return Arrays.stream(settings.getMirroredProjects()).map(AoMirroredProject::getExternalId).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    public static UpstreamSettings toMirrorSettings(AoUpstreamSettings settings) {
        if (settings == null) {
            return null;
        }
        MirroringMode mode = MirroringMode.fromId(settings.getMode());
        SimpleUpstreamSettings.Builder builder = new SimpleUpstreamSettings.Builder().mode(mode);
        if (mode == MirroringMode.ALL_PROJECTS) {
            return builder.build();
        }
        return builder.projectIds(UpstreamSettingsUtils.getMirroredProjectIds(settings)).build();
    }

    public static UpstreamSettings toMirrorSettings(AoUpstreamSettings settings, Date lastSettingsChangeDate) {
        if (settings == null) {
            return null;
        }
        MirroringMode mode = MirroringMode.fromId(settings.getMode());
        SimpleUpstreamSettings.Builder builder = new SimpleUpstreamSettings.Builder().mode(mode).lastUpdatedTime(lastSettingsChangeDate);
        if (mode == MirroringMode.ALL_PROJECTS) {
            return builder.build();
        }
        return builder.projectIds(UpstreamSettingsUtils.getMirroredProjectIds(settings)).build();
    }
}

