/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.cluster;

import com.atlassian.bitbucket.cluster.ClusterInformation;
import com.atlassian.bitbucket.cluster.ClusterNode;
import com.atlassian.bitbucket.cluster.ClusterService;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ClusterInfoContextProvider
implements ContextProvider {
    private final ClusterService clusterService;

    public ClusterInfoContextProvider(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    public void init(Map<String, String> stringStringMap) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> stringObjectMap) {
        ClusterInformation clusterInformation = this.clusterService.getInformation();
        ClusterNode localNode = clusterInformation.getLocalNode();
        String nodeLabel = this.makeNodeLabel(localNode);
        return ImmutableMap.of((Object)"nodeLabel", (Object)nodeLabel, (Object)"nodeCount", (Object)clusterInformation.getNodes().size());
    }

    private String makeNodeLabel(ClusterNode clusterNode) {
        String nodeName = clusterNode.getName();
        String nodeId = clusterNode.getId();
        return StringUtils.isNotEmpty((CharSequence)nodeName) ? nodeName + " (" + nodeId + ")" : nodeId;
    }
}

