/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.process;

import com.atlassian.bitbucket.internal.process.NioProcessConfigurer;
import com.atlassian.bitbucket.internal.process.NioProcessParameters;
import com.atlassian.bitbucket.server.StorageService;
import jakarta.annotation.Nonnull;
import java.nio.file.Path;
import java.time.Duration;
import org.apache.commons.lang3.SystemUtils;

public class DefaultNioProcessConfigurer
implements NioProcessConfigurer {
    private final Duration executionInterval;
    private final Duration idleInterval;
    private final Path tempDir;
    private final String tempPath;

    public DefaultNioProcessConfigurer(StorageService storageService, long executionInterval, long idleInterval) {
        this.executionInterval = Duration.ofSeconds(executionInterval);
        this.idleInterval = Duration.ofSeconds(idleInterval);
        this.tempDir = storageService.getTempDir();
        this.tempPath = this.tempDir.toAbsolutePath().toString();
    }

    @Override
    public void configure(@Nonnull NioProcessParameters<?> parameters) {
        parameters.environmentPutIfAbsent("TMPDIR", this.tempPath);
        if (SystemUtils.IS_OS_WINDOWS) {
            parameters.environmentPutIfAbsent("TEMP", this.tempPath);
            parameters.environmentPutIfAbsent("TMP", this.tempPath);
        }
        if (parameters.getWorkDir() == null) {
            parameters.setWorkDir(this.tempDir);
        }
        if (parameters.getExecutionInterval() == null) {
            parameters.setExecutionInterval(this.executionInterval);
        }
        if (parameters.getIdleInterval() == null) {
            parameters.setIdleInterval(this.idleInterval);
        }
    }
}

