/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.process;

import com.atlassian.bitbucket.internal.process.NioProcessHelper;
import com.atlassian.bitbucket.internal.process.NioProcessParameters;
import com.atlassian.bitbucket.scm.AsyncCommand;
import com.atlassian.bitbucket.scm.Command;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Future;

public class NioCommand<T>
implements Command<T>,
AsyncCommand<T> {
    private final NioProcessParameters<T> parameters;
    private final NioProcessHelper processHelper;
    private volatile boolean startable;

    public NioCommand(@Nonnull NioProcessHelper processHelper, @Nonnull NioProcessParameters<T> parameters) {
        this.parameters = Objects.requireNonNull(parameters, "parameters");
        this.processHelper = Objects.requireNonNull(processHelper, "processHelper");
        this.startable = true;
    }

    @Nonnull
    public NioCommand<T> asynchronous() {
        this.startable = true;
        return this;
    }

    public T call() {
        try (Ticker ignored = Timers.start((String)("nio: " + String.valueOf(this.parameters)));){
            T t = this.processHelper.run(this.parameters);
            return t;
        }
    }

    public void setExecutionTimeout(@Nonnull Duration timeout) {
        this.parameters.setExecutionInterval(Objects.requireNonNull(timeout, "executionTimeout"));
    }

    public void setExecutionTimeout(long timeoutInSecs) {
        this.parameters.setExecutionInterval(Duration.ofSeconds(timeoutInSecs));
    }

    public void setIdleTimeout(@Nonnull Duration timeout) {
        this.parameters.setIdleInterval(Objects.requireNonNull(timeout, "idleTimeout"));
    }

    public void setIdleTimeout(long timeoutInSecs) {
        this.parameters.setIdleInterval(Duration.ofSeconds(timeoutInSecs));
    }

    public void setTimeout(@Nonnull Duration timeout) {
        this.parameters.setExecutionInterval(Objects.requireNonNull(timeout, "timeout"));
        this.parameters.setIdleInterval(timeout);
    }

    @Nonnull
    public Future<T> start() {
        if (!this.startable) {
            throw new IllegalStateException("This AsyncCommand has been converted to synchronous. It may no longer be started asynchronously.");
        }
        return this.processHelper.start(this.parameters);
    }

    @Nonnull
    public NioCommand<T> synchronous() {
        this.startable = false;
        return this;
    }

    @Nonnull
    public String toString() {
        return this.parameters.toString();
    }
}

