/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.process;

import com.atlassian.bitbucket.dmz.process.NioStdioHandler;
import com.atlassian.bitbucket.scm.CommandExitHandler;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class NioProcessParameters<T> {
    private final List<String> arguments;
    private final Map<String, String> environment;
    private final CommandExitHandler exitHandler;
    private final NioStdioHandler<T> stdioHandler;
    private final boolean throwOnNonZeroExit;
    private Duration executionInterval;
    private Duration idleInterval;
    private Path workDir;

    private NioProcessParameters(Builder<T> builder) {
        this.arguments = builder.arguments.build();
        this.environment = builder.environment;
        this.executionInterval = builder.executionInterval;
        this.exitHandler = builder.exitHandler;
        this.idleInterval = builder.idleInterval;
        this.stdioHandler = builder.stdioHandler;
        this.throwOnNonZeroExit = builder.throwOnNonZeroExit;
        this.workDir = builder.workDir;
    }

    public void environmentPut(@Nonnull String key, @Nonnull String value) {
        NioProcessParameters.requireNonBlankAndNoNullChar(key, "key");
        NioProcessParameters.requireNoNullChars(value);
        this.environment.put(key, value);
    }

    public void environmentPutIfAbsent(@Nonnull String key, @Nonnull String value) {
        NioProcessParameters.requireNonBlankAndNoNullChar(key, "key");
        NioProcessParameters.requireNoNullChars(value);
        this.environment.putIfAbsent(key, value);
    }

    @Nonnull
    public List<String> getArguments() {
        return this.arguments;
    }

    @Nonnull
    public Map<String, String> getEnvironment() {
        return Collections.unmodifiableMap(this.environment);
    }

    @Nullable
    public Duration getExecutionInterval() {
        return this.executionInterval;
    }

    @Nonnull
    public CommandExitHandler getExitHandler() {
        return this.exitHandler;
    }

    @Nullable
    public Duration getIdleInterval() {
        return this.idleInterval;
    }

    @Nonnull
    public NioStdioHandler<T> getStdioHandler() {
        return this.stdioHandler;
    }

    @Nullable
    public Path getWorkDir() {
        return this.workDir;
    }

    public boolean isThrowOnNonZeroExit() {
        return this.throwOnNonZeroExit;
    }

    public void setExecutionInterval(@Nullable Duration executionInterval) {
        this.executionInterval = executionInterval;
    }

    public void setIdleInterval(@Nullable Duration idleInterval) {
        this.idleInterval = idleInterval;
    }

    public void setWorkDir(@Nullable Path workDir) {
        this.workDir = workDir;
    }

    public String toString() {
        return String.join((CharSequence)" ", this.arguments);
    }

    private static String requireNoNullChars(String value) {
        Objects.requireNonNull(value, "value");
        if (value.indexOf(0) >= 0) {
            throw new IllegalArgumentException("Unsupported \\0 character detected: " + value);
        }
        return value;
    }

    private static String requireNonBlankAndNoNullChar(String value, String name) {
        if (StringUtils.isBlank((CharSequence)value)) {
            throw new IllegalArgumentException("A non-blank " + StringUtils.defaultString((String)name, (String)"value") + " is required");
        }
        NioProcessParameters.requireNoNullChars(value);
        return value;
    }

    public static class Builder<T>
    extends BuilderSupport {
        private final ImmutableList.Builder<String> arguments;
        private final Map<String, String> environment;
        private final CommandExitHandler exitHandler;
        private final NioStdioHandler<T> stdioHandler;
        private Duration executionInterval;
        private Duration idleInterval;
        private boolean throwOnNonZeroExit;
        private Path workDir;

        public Builder(@Nonnull NioStdioHandler<T> stdioHandler, @Nonnull CommandExitHandler exitHandler) {
            this.exitHandler = Objects.requireNonNull(exitHandler, "exitHandler");
            this.stdioHandler = Objects.requireNonNull(stdioHandler, "stdioHandler");
            this.arguments = ImmutableList.builder();
            this.environment = new HashMap<String, String>();
            this.throwOnNonZeroExit = true;
        }

        @Nonnull
        public Builder<T> argument(@Nullable String value) {
            Builder.addIf(Builder::nonNullAndNoNullChar, this.arguments, (Object)value);
            return this;
        }

        @Nonnull
        public Builder<T> arguments(@Nullable Iterable<String> values) {
            Builder.addIf(Builder::nonNullAndNoNullChar, this.arguments, values);
            return this;
        }

        @Nonnull
        public Builder<T> arguments(@Nullable String value, String ... values) {
            Builder.addIf(Builder::nonNullAndNoNullChar, this.arguments, (Object)value, (Object[])values);
            return this;
        }

        @Nonnull
        public NioProcessParameters<T> build() {
            return new NioProcessParameters(this);
        }

        @Nonnull
        public Builder<T> environment(@Nonnull Map<String, String> map) {
            Objects.requireNonNull(map, "environment").forEach((key, value) -> {
                NioProcessParameters.requireNonBlankAndNoNullChar(key, "key");
                NioProcessParameters.requireNoNullChars(value);
            });
            this.environment.putAll(map);
            return this;
        }

        @Nonnull
        public Builder<T> environment(@Nonnull String key, @Nonnull String value) {
            this.environment.put(NioProcessParameters.requireNonBlankAndNoNullChar(key, "key"), NioProcessParameters.requireNoNullChars(value));
            return this;
        }

        @Nonnull
        public Builder<T> executionInterval(@Nullable Duration value) {
            this.executionInterval = value;
            return this;
        }

        @Nonnull
        public Builder<T> idleInterval(@Nullable Duration value) {
            this.idleInterval = value;
            return this;
        }

        @Nonnull
        public Builder<T> throwOnNonZeroExit(boolean value) {
            this.throwOnNonZeroExit = value;
            return this;
        }

        @Nonnull
        public Builder<T> workDir(@Nullable Path value) {
            this.workDir = value;
            return this;
        }

        private static boolean nonNullAndNoNullChar(String value) {
            if (value == null) {
                return false;
            }
            NioProcessParameters.requireNoNullChars(value);
            return true;
        }
    }
}

