/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.process.nu;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.process.NioProcessParameters;
import com.atlassian.bitbucket.internal.process.nu.NioNuProcessHandler;
import com.zaxxer.nuprocess.NuProcess;
import jakarta.annotation.Nonnull;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;

class LatchedNioNuProcessHandler<T>
extends NioNuProcessHandler<T> {
    private final CountDownLatch latch = new CountDownLatch(1);

    LatchedNioNuProcessHandler(I18nService i18nService, NioProcessParameters<T> parameters, ScheduledExecutorService timeoutExecutor) {
        super(i18nService, parameters, timeoutExecutor);
    }

    @Override
    public void onExit(int exitCode) {
        try {
            super.onExit(exitCode);
        }
        finally {
            this.latch.countDown();
        }
    }

    @Override
    public void onStart(NuProcess nuProcess) {
        try {
            super.onStart(nuProcess);
        }
        finally {
            this.latch.countDown();
        }
    }

    @Override
    @Nonnull
    Future<T> asFuture() {
        try {
            this.latch.await();
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
        return super.asFuture();
    }
}

