/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.process.nu;

import com.atlassian.bitbucket.dmz.process.NioProcess;
import com.zaxxer.nuprocess.NuProcess;
import jakarta.annotation.Nonnull;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NuNioProcess
implements NioProcess {
    private static final Logger log = LoggerFactory.getLogger(NuNioProcess.class);
    private final String commandLine;
    private final NuProcess process;
    private volatile boolean canceled;
    private volatile boolean destroyed;

    NuNioProcess(@Nonnull NuProcess process, @Nonnull String commandLine) {
        this.commandLine = Objects.requireNonNull(commandLine, "commandLine");
        this.process = Objects.requireNonNull(process, "process");
    }

    public void cancel() {
        this.canceled = true;
        this.destroyIfRunning();
    }

    public void closeStdin(boolean force) {
        this.process.closeStdin(force);
    }

    public boolean hasPendingWrites() {
        return this.process.hasPendingWrites();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public boolean isRunning() {
        return this.process.isRunning();
    }

    public void wantWrite() {
        if (this.canceled) {
            log.debug("{}: Dropping wantWrite(); the process has been canceled", (Object)this.commandLine);
        } else if (this.process.isRunning()) {
            this.process.wantWrite();
        } else {
            log.debug("{}: Dropping wantWrite(); the process is not running", (Object)this.commandLine);
        }
    }

    public void writeStdin(@Nonnull ByteBuffer buffer) {
        this.process.writeStdin(buffer);
    }

    public String toString() {
        return this.commandLine;
    }

    void destroyIfRunning() {
        if (this.process.isRunning()) {
            try {
                this.process.closeStdin(true);
            }
            finally {
                this.process.destroy(this.destroyed);
                this.destroyed = true;
            }
        }
    }

    int getPid() {
        return this.process.getPID();
    }

    void terminateIfRunning() {
        if (this.process.isRunning()) {
            this.process.destroy(false);
            try {
                this.process.waitFor(5L, TimeUnit.SECONDS);
                if (this.process.isRunning()) {
                    this.process.destroy(true);
                }
            }
            catch (InterruptedException e) {
                log.warn("{}: Interrupted while terminating", (Object)this.commandLine);
                Thread.currentThread().interrupt();
            }
        }
    }
}

