/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.process.nu;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.process.NioProcessConfigurer;
import com.atlassian.bitbucket.internal.process.NioProcessHelper;
import com.atlassian.bitbucket.internal.process.NioProcessParameters;
import com.atlassian.bitbucket.internal.process.NioUnsupportedException;
import com.atlassian.bitbucket.internal.process.nu.LatchedNioNuProcessHandler;
import com.atlassian.bitbucket.internal.process.nu.NioNuProcessHandler;
import com.atlassian.bitbucket.util.MoreFiles;
import com.atlassian.bitbucket.util.concurrent.ExecutorUtils;
import com.atlassian.stash.internal.concurrent.ConcurrencyUtils;
import com.google.common.collect.ImmutableList;
import com.zaxxer.nuprocess.NuAbstractProcessHandler;
import com.zaxxer.nuprocess.NuProcess;
import com.zaxxer.nuprocess.NuProcessBuilder;
import com.zaxxer.nuprocess.NuProcessHandler;
import io.atlassian.util.concurrent.ThreadFactories;
import jakarta.annotation.Nonnull;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NuNioProcessHelper
implements NioProcessHelper {
    private static final String PROP_THREADS = "com.zaxxer.nuprocess.threads";
    private final ExecutorService asyncExecutor;
    private final List<NioProcessConfigurer> configurers;
    private final I18nService i18nService;
    private final ScheduledExecutorService timeoutExecutor;

    public NuNioProcessHelper(I18nService i18nService, NioProcessConfigurer ... configurers) {
        this(NuNioProcessHelper.newAsyncExecutor(), i18nService, ConcurrencyUtils.createScheduledExecutor((String)"nio-timeout"), configurers);
    }

    public NuNioProcessHelper(ExecutorService asyncExecutor, I18nService i18nService, ScheduledExecutorService timeoutExecutor, NioProcessConfigurer ... configurers) {
        this.asyncExecutor = asyncExecutor;
        this.configurers = ImmutableList.copyOf((Object[])configurers);
        this.i18nService = i18nService;
        this.timeoutExecutor = timeoutExecutor;
        if (System.getProperty(PROP_THREADS) == null) {
            int threads = Math.max(2, Runtime.getRuntime().availableProcessors());
            System.setProperty(PROP_THREADS, Integer.toString(threads));
        }
    }

    @Override
    public <T> T run(@Nonnull NioProcessParameters<T> parameters) {
        this.applyConfigurers(parameters);
        NioNuProcessHandler<T> handler = new NioNuProcessHandler<T>(this.i18nService, parameters, this.timeoutExecutor);
        this.createProcessBuilder(parameters, handler).run();
        return handler.asResult();
    }

    public void shutdown() {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        try {
            ExecutorUtils.shutdown((ExecutorService)this.asyncExecutor, (Logger)logger);
        }
        finally {
            ExecutorUtils.shutdown((ExecutorService)this.timeoutExecutor, (Logger)logger);
        }
    }

    @Override
    @Nonnull
    public <T> Future<T> start(@Nonnull NioProcessParameters<T> parameters) {
        this.applyConfigurers(parameters);
        LatchedNioNuProcessHandler<T> handler = new LatchedNioNuProcessHandler<T>(this.i18nService, parameters, this.timeoutExecutor);
        NuProcessBuilder builder = this.createProcessBuilder(parameters, handler);
        this.asyncExecutor.execute(() -> ((NuProcessBuilder)builder).run());
        return handler.asFuture();
    }

    public void validate() {
        final MutableBoolean success = new MutableBoolean();
        try {
            NuProcessBuilder builder = new NuProcessBuilder(new String[]{NuNioProcessHelper.getJavaBinary(), "-version"});
            builder.setProcessListener((NuProcessHandler)new NuAbstractProcessHandler(this){
                private volatile boolean started;

                public void onExit(int statusCode) {
                    if (this.started) {
                        success.setTrue();
                    }
                }

                public void onStart(NuProcess nuProcess) {
                    this.started = true;
                }
            });
            builder.run();
        }
        catch (Throwable t) {
            throw new NioUnsupportedException("Failed to initialize NIO", t);
        }
        if (success.isFalse()) {
            throw new NioUnsupportedException("Failed to start test process");
        }
    }

    private static String getJavaBinary() {
        Object javaBinary = "java";
        if (SystemUtils.IS_OS_WINDOWS) {
            javaBinary = (String)javaBinary + ".exe";
        }
        return MoreFiles.resolve((Path)Paths.get(System.getProperty("java.home"), new String[0]), (String)"bin", (String[])new String[]{javaBinary}).toAbsolutePath().toString();
    }

    private static ExecutorService newAsyncExecutor() {
        return Executors.newCachedThreadPool(ThreadFactories.namedThreadFactory((String)"nio-pump", (ThreadFactories.Type)ThreadFactories.Type.DAEMON));
    }

    private void applyConfigurers(NioProcessParameters<?> parameters) {
        for (NioProcessConfigurer configurer : this.configurers) {
            configurer.configure(parameters);
        }
    }

    private NuProcessBuilder createProcessBuilder(NioProcessParameters<?> parameters, NuProcessHandler handler) {
        NuProcessBuilder builder = new NuProcessBuilder(handler, parameters.getArguments());
        builder.environment().putAll(parameters.getEnvironment());
        builder.setCwd(parameters.getWorkDir());
        return builder;
    }
}

