/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.enrich;

import com.atlassian.bitbucket.markup.RenderContext;
import com.atlassian.bitbucket.markup.UrlMode;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class MarkupRequestHelper {
    private MarkupRequestHelper() {
    }

    @Nonnull
    public static RenderContext makeRenderContext(@Nonnull UriInfo uriInfo) {
        MultivaluedMap parameters = Objects.requireNonNull(uriInfo, "uriInfo").getQueryParameters();
        return new RenderContext.Builder().hardwrap(MarkupRequestHelper.parseBoolean((MultivaluedMap<String, String>)parameters, "hardwrap")).htmlEscape(MarkupRequestHelper.parseBoolean((MultivaluedMap<String, String>)parameters, "htmlEscape")).includeHeadingId(MarkupRequestHelper.parseBoolean((MultivaluedMap<String, String>)parameters, "includeHeadingId")).urlMode(MarkupRequestHelper.parseUrlMode((MultivaluedMap<String, String>)parameters)).build();
    }

    private static Boolean parseBoolean(MultivaluedMap<String, String> parameters, String key) {
        String value = (String)parameters.getFirst((Object)key);
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        return Boolean.valueOf(value);
    }

    private static UrlMode parseUrlMode(MultivaluedMap<String, String> parameters) {
        String value = (String)parameters.getFirst((Object)"urlMode");
        if (StringUtils.isBlank((CharSequence)value)) {
            return UrlMode.RELATIVE;
        }
        try {
            return UrlMode.valueOf((String)value.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("urlMode", "\"" + value + "\" is not a valid value for \"urlMode\"; valid values are: " + String.valueOf(ImmutableList.copyOf((Object[])UrlMode.values())));
        }
    }
}

