/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.mirror.MirrorAvailable;
import com.atlassian.bitbucket.dmz.rest.v2.server.RestApplicationProperties;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import com.atlassian.sal.api.ApplicationProperties;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@Path(value="application-properties")
@MirrorAvailable
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@UnrestrictedAccess
@Tag(name="System Maintenance")
public class ApplicationPropertiesResource {
    private final ApplicationProperties applicationProperties;

    @Inject
    public ApplicationPropertiesResource(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    @Operation(description="Retrieve version information and other application properties.\n\nNo authentication is required to call this resource.", summary="Get application properties")
    @ResponseDocs(value={@ResponseDoc(documentation="The application properties", responseCode=200, representation=RestApplicationProperties.class)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getApplicationProperties() {
        return ResponseFactory.ok((Object)new RestApplicationProperties(this.applicationProperties.getVersion(), this.applicationProperties.getBuildNumber(), String.valueOf(this.applicationProperties.getBuildDate().getTime()), this.applicationProperties.getDisplayName())).build();
    }
}

