/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.label.LabelService;
import com.atlassian.bitbucket.rest.v2.api.exception.PluginNotAvailableException;
import com.atlassian.stash.internal.rest.OptionalServiceRegistry;
import com.atlassian.webhooks.WebhookService;
import com.atlassian.webhooks.history.InvocationHistoryService;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PreDestroy;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class DefaultOptionalServiceRegistry
implements OptionalServiceRegistry {
    private final I18nService i18nService;
    private final ServiceTracker<Object, Object> invocationHistoryServiceTracker;
    private final ServiceTracker<Object, Object> labelServiceTracker;
    private final ServiceTracker<Object, Object> webhookServiceTracker;

    public DefaultOptionalServiceRegistry(BundleContext bundleContext, I18nService i18nService) {
        this.i18nService = i18nService;
        this.invocationHistoryServiceTracker = new ServiceTracker(bundleContext, "com.atlassian.webhooks.history.InvocationHistoryService", null);
        this.invocationHistoryServiceTracker.open();
        this.labelServiceTracker = new ServiceTracker(bundleContext, "com.atlassian.bitbucket.label.LabelService", null);
        this.labelServiceTracker.open();
        this.webhookServiceTracker = new ServiceTracker(bundleContext, "com.atlassian.webhooks.WebhookService", null);
        this.webhookServiceTracker.open();
    }

    @PreDestroy
    public void destroy() {
        this.invocationHistoryServiceTracker.close();
        this.webhookServiceTracker.close();
    }

    @Override
    @Nonnull
    public InvocationHistoryService getInvocationHistoryServiceOrThrow() {
        Object service = this.invocationHistoryServiceTracker.getService();
        if (service == null) {
            throw this.pluginNotAvailable("atlassian-webhooks");
        }
        return (InvocationHistoryService)service;
    }

    @Override
    @Nonnull
    public LabelService getLabelServiceOrThrow() {
        Object service = this.labelServiceTracker.getService();
        if (service == null) {
            throw this.pluginNotAvailable("bitbucket-labels");
        }
        return (LabelService)service;
    }

    @Override
    @Nonnull
    public WebhookService getWebhookServiceOrThrow() {
        Object service = this.webhookServiceTracker.getService();
        if (service == null) {
            throw this.pluginNotAvailable("atlassian-webhooks");
        }
        return (WebhookService)service;
    }

    private PluginNotAvailableException pluginNotAvailable(String pluginName) {
        throw new PluginNotAvailableException(this.i18nService.createKeyedMessage("bitbucket.rest.plugin.not.available", new Object[]{pluginName}));
    }
}

