/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.admin;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.admin.banner.DmzAnnouncementBannerService;
import com.atlassian.bitbucket.dmz.admin.banner.SetAnnouncementBannerRequest;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.util.ValidationUtils;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.AdminOnly;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.stash.internal.rest.admin.RestAnnouncementBanner;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.validation.Validator;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@AdminOnly
@Consumes(value={"application/json"})
@Path(value="admin/banner")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="System Maintenance")
@WebSudoRequired
public class AnnouncementBannerResource {
    private final DmzAnnouncementBannerService announcementBannerService;
    private final Validator validator;

    @Inject
    public AnnouncementBannerResource(DmzAnnouncementBannerService announcementBannerService, Validator validator) {
        this.announcementBannerService = announcementBannerService;
        this.validator = validator;
    }

    @Operation(description="Gets the announcement banner, if one exists and is available to the user", summary="Get announcement banner")
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="The requested banner", representation=RestAnnouncementBanner.class), @ResponseDoc(responseCode=204, documentation="There is no banner to display"), @ResponseDoc(responseCode=401, documentation="The user does not have permission to access the banner service through this endpoint", restError=true)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getBanner() {
        return this.announcementBannerService.getConfiguredBanner().map(RestAnnouncementBanner::new).map(restAnnouncementBanner -> ResponseFactory.ok((Object)restAnnouncementBanner).build()).orElseGet(() -> ResponseFactory.noContent().build());
    }

    @Operation(description="Sets the announcement banner with the provided JSON.\nOnly users authenticated as Admins may call this resource", summary="Update/Set announcement banner")
    @Parameter(description="Representation of the new banner", required=true)
    @ResponseDocs(value={@ResponseDoc(responseCode=204, documentation="The banner was set successfully"), @ResponseDoc(responseCode=400, documentation="There was malformed or incorrect data in the provided JSON", restError=true), @ResponseDoc(responseCode=401, documentation="The user does not have permission to access the banner service through this endpoint", restError=true)})
    @PUT
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response setBanner(RestAnnouncementBanner restAnnouncementBanner) {
        ValidationUtils.validate((Validator)this.validator, (Object)((Object)restAnnouncementBanner), (Class[])new Class[0]);
        SetAnnouncementBannerRequest request = new SetAnnouncementBannerRequest.Builder().audience(restAnnouncementBanner.getAudience()).enabled(restAnnouncementBanner.isEnabled()).message(restAnnouncementBanner.getMessage()).build();
        this.announcementBannerService.setBanner(request);
        return ResponseFactory.noContent().build();
    }

    @Operation(description="Deletes a banner, if one is present in the database.", summary="Delete announcement banner")
    @ResponseDocs(value={@ResponseDoc(responseCode=204, documentation="The query executed successfully, whether a banner was deleted or not"), @ResponseDoc(responseCode=401, documentation="The user does not have permission to access the banner service through this endpoint", restError=true)})
    @DELETE
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response deleteBanner() {
        this.announcementBannerService.deleteBanner();
        return ResponseFactory.noContent().build();
    }
}

