/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.admin;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.stash.internal.rest.admin.RestDefaultBranch;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Path(value="admin/default-branch")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="System Maintenance")
public class DefaultBranchResource {
    private final RepositoryService repositoryService;

    @Inject
    public DefaultBranchResource(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    @Operation(description="Clears the global default branch, which is used when creating new repositories if an explicit default branch is not specified, if one has been configured.\n\nThe authenticated user must have <strong>ADMIN</strong> permission to call this resource.", summary="Clear default branch")
    @ResponseDocs(value={@ResponseDoc(responseCode=204, documentation="The default branch has been cleared."), @ResponseDoc(responseCode=401, documentation="The current user does not have sufficient permissions to clear the global default branch.", restError=true)})
    @DELETE
    @WebSudoRequired
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response clearDefaultBranch() {
        return this.setDefaultBranch((String)null);
    }

    @Operation(description="Retrieves the configured global default branch, which is used when creating new repositories if an explicit default branch is not specified.\n\nThe user must be authenticated to call this resource.", summary="Get the default branch")
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="The configured global default branch."), @ResponseDoc(responseCode=404, documentation="No global default branch has been configured.", restError=true)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getDefaultBranch() {
        String defaultBranch = this.repositoryService.getDefaultBranch();
        if (defaultBranch == null) {
            return ResponseFactory.notFound().build();
        }
        return ResponseFactory.ok((Object)((Object)new RestDefaultBranch(defaultBranch))).build();
    }

    @Operation(description="Configures the global default branch, which is used when creating new repositories if an explicit default branch is not specified.\n\nThe authenticated user must have <strong>ADMIN</strong> permission to call this resource.", summary="Update/Set default branch")
    @Parameter(description="The default branch to configure")
    @ResponseDocs(value={@ResponseDoc(responseCode=204, documentation="The default branch has been set."), @ResponseDoc(responseCode=401, documentation="The current user does not have sufficient permissions to configure the global default branch.", restError=true)})
    @PUT
    @WebSudoRequired
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response setDefaultBranch(RestDefaultBranch defaultBranch) {
        return this.setDefaultBranch(defaultBranch.getId());
    }

    private Response setDefaultBranch(String defaultBranch) {
        this.repositoryService.setDefaultBranch(defaultBranch);
        return Response.noContent().build();
    }
}

