/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.admin;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.rest.v2.mail.RestMailConfiguration;
import com.atlassian.bitbucket.mail.MailHostConfiguration;
import com.atlassian.bitbucket.mail.MailProtocol;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.base.MoreObjects;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Path(value="admin/mail-server")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="System Maintenance")
public class MailServerResource {
    public static final String EXAMPLE_SENDER_ADDRESS = "stash-no-reply@company.com";
    private final PermissionValidationService permissionValidationService;
    private final ApplicationPropertiesService propertiesService;
    private final TransactionTemplate transactionTemplate;

    @Inject
    public MailServerResource(PermissionValidationService permissionValidationService, ApplicationPropertiesService propertiesService, TransactionTemplate transactionTemplate) {
        this.permissionValidationService = permissionValidationService;
        this.propertiesService = propertiesService;
        this.transactionTemplate = transactionTemplate;
    }

    @Operation(description="Deletes the current mail configuration.\n\nThe authenticated user must have the <strong>SYS_ADMIN</strong> permission to call this resource.", summary="Delete mail configuration")
    @ResponseDocs(value={@ResponseDoc(responseCode=204, documentation="The mail configuration was successfully deleted."), @ResponseDoc(responseCode=401, documentation="The currently authenticated user has insufficient permissions to delete the mail server configuration.", restError=true)})
    @DELETE
    @WebSudoRequired
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response deleteMailConfig() {
        this.propertiesService.deleteMailHostConfiguration();
        this.propertiesService.setServerEmailAddress(null);
        return ResponseFactory.noContent().build();
    }

    @Operation(description="Retrieves the current mail configuration. \n\nThe authenticated user must have the <strong>SYS_ADMIN</strong> permission to call this resource.", summary="Get mail configuration")
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="The mail configuration", representation=RestMailConfiguration.class), @ResponseDoc(responseCode=401, documentation="The currently authenticated user has insufficient permissions to retrieve the mail configuration.", restError=true), @ResponseDoc(responseCode=404, documentation="The mail server hasn't been configured", restError=true)})
    @WebSudoRequired
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getMailConfig() {
        this.permissionValidationService.validateForGlobal(Permission.SYS_ADMIN);
        MailHostConfiguration configuration = this.propertiesService.getMailHostConfiguration();
        String senderAddress = this.propertiesService.getServerEmailAddress();
        return configuration == null && senderAddress == null ? ResponseFactory.notFound().build() : ResponseFactory.ok((Object)new RestMailConfiguration(configuration, senderAddress)).build();
    }

    @Operation(description="Updates the mail configuration. \n\nThe authenticated user must have the <strong>SYS_ADMIN</strong> permission to call this resource.", summary="Update mail configuration")
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="The updated mail configuration.", representation=RestMailConfiguration.class), @ResponseDoc(responseCode=400, documentation="The mail configuration was not updated due to a validation error.", restError=true), @ResponseDoc(responseCode=401, documentation="The currently authenticated user has insufficient permissions to update themail configuration.", restError=true)})
    @PUT
    @WebSudoRequired
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response setMailConfig(final RestMailConfiguration configuration) {
        this.permissionValidationService.validateForGlobal(Permission.ADMIN);
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction() {
                if (StringUtils.isNotBlank((CharSequence)configuration.getHostname())) {
                    MailServerResource.this.propertiesService.setMailHostConfiguration(new MailHostConfiguration.Builder().hostname(configuration.getHostname()).port(configuration.getPort()).protocol((MailProtocol)MoreObjects.firstNonNull((Object)configuration.getProtocol(), (Object)MailProtocol.SMTP)).requireStartTls(configuration.isRequireStartTls()).useStartTls(configuration.isUseStartTls()).username(configuration.getUsername()).password(configuration.getPassword()).build());
                }
                if (StringUtils.isNotBlank((CharSequence)configuration.getSenderAddress())) {
                    MailServerResource.this.propertiesService.setServerEmailAddress(configuration.getSenderAddress());
                }
                return null;
            }
        });
        return ResponseFactory.ok((Object)new RestMailConfiguration(this.propertiesService.getMailHostConfiguration(), this.propertiesService.getServerEmailAddress())).build();
    }

    @Operation(description="Clears the server email address.\n\nThe authenticated user must have the <strong>ADMIN</strong> permission to call this resource.", summary="Update mail configuration")
    @ResponseDocs(value={@ResponseDoc(responseCode=204, documentation="he server email address was successfully cleared."), @ResponseDoc(responseCode=401, documentation="The currently authenticated user has insufficient permissions toclear the server email address.", restError=true)})
    @DELETE
    @Path(value="sender-address")
    @WebSudoRequired
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response clearSenderAddress() {
        this.propertiesService.setServerEmailAddress(null);
        return ResponseFactory.noContent().build();
    }

    @Operation(description="Retrieves the server email address", summary="Get server mail address")
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="The server email address"), @ResponseDoc(responseCode=401, documentation="he currently authenticated user has insufficient permissions to retrieve the server email address.", restError=true)})
    @GET
    @Path(value="sender-address")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getSenderAddress() {
        this.permissionValidationService.validateForGlobal(Permission.LICENSED_USER);
        String address = this.propertiesService.getServerEmailAddress();
        return address == null ? ResponseFactory.notFound().build() : ResponseFactory.ok((Object)address).build();
    }

    @Operation(description="Updates the server email address \n\nThe authenticated user must have the <strong>ADMIN</strong> permission to call this resource.", summary="Update server mail address")
    @Parameter(description="The sender address", example="stash-no-reply@company.com")
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="The from address used in notification emails"), @ResponseDoc(responseCode=400, documentation="The server email address was not updated due to a validation error.", restError=true), @ResponseDoc(responseCode=401, documentation="The currently authenticated user has insufficient permissions to update the server email address.", restError=true)})
    @PUT
    @Path(value="sender-address")
    @WebSudoRequired
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response setSenderAddress(String senderAddress) {
        this.propertiesService.setServerEmailAddress(senderAddress);
        return ResponseFactory.ok((Object)this.propertiesService.getServerEmailAddress()).build();
    }
}

