/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.admin;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.pull.DmzPullRequestService;
import com.atlassian.bitbucket.dmz.rest.v2.pull.RestPullRequestMergeConfig;
import com.atlassian.bitbucket.dmz.rest.v2.pull.RestPullRequestMergeStrategy;
import com.atlassian.bitbucket.dmz.rest.v2.pull.RestPullRequestSettings;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.pull.DeletePullRequestMergeConfigRequest;
import com.atlassian.bitbucket.pull.GetPullRequestMergeConfigRequest;
import com.atlassian.bitbucket.pull.SetPullRequestMergeConfigRequest;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.scm.FeatureUnsupportedScmException;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.stash.internal.rest.pull.AbstractPullRequestResource;
import com.atlassian.stash.internal.rest.util.RestMergeConfigUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Set;

@Tag(name="Pull Requests")
@LicensedOnly
@Consumes(value={"application/json"})
@Path(value="admin/pull-requests/{scmId}")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class MergeConfigResource
extends AbstractPullRequestResource {
    @Inject
    public MergeConfigResource(I18nService i18nService, DmzPullRequestService pullRequestService) {
        super(i18nService, pullRequestService);
    }

    @Operation(description="Retrieve the merge strategies available for this instance. \n\nThe user must be authenticated to call this resource.", summary="Get merge strategies")
    @Parameter(description="the id of the scm to get strategies for", in=ParameterIn.PATH, name="scmId")
    @ResponseDocs(value={@ResponseDoc(documentation="The merge configuration of this instance.", representation=RestPullRequestMergeConfig.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to see the request repository.", restError=true, responseCode=401), @ResponseDoc(documentation="The request repository does not exist", restError=true, responseCode=404)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getMergeConfig(@PathParam(value="scmId") String scmId) {
        try {
            return ResponseFactory.ok((Object)this.readPullRequestSettings(scmId)).build();
        }
        catch (FeatureUnsupportedScmException e) {
            return ResponseFactory.noContent().build();
        }
    }

    @Operation(description="Update the pull request merge strategies for the context repository. \n\nThe authenticated user must have <strong>ADMIN</strong> permission to call this resource. \n\nOnly the strategies provided will be enabled, only one may be set to default \n\nThe commit message template will not be updated if not provided, and will be deleted if the `commitMessageTemplate` attribute is empty, i.e: `commitMessageTemplate: {}`.\n\nAn explicitly set pull request merge strategy configuration can be deleted by POSTing a document with an empty `mergeConfig` attribute. i.e:\n```\n{ \n    \"mergeConfig\": {} \n} \n```\n\nUpon completion of this request, the effective configuration will be the default configuration.", summary="Update merge strategies")
    @Parameter(description="the id of the scm to get strategies for", in=ParameterIn.PATH, name="scmId")
    @RequestBody(description="the settings", content={@Content(schema=@Schema(implementation=RestPullRequestSettings.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="The repository pull request merge strategies for the context repository.", representation=RestPullRequestMergeConfig.class, responseCode=200), @ResponseDoc(documentation="The repository pull request merge strategies were not updated due to a validation error.", restError=true, responseCode=400), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to administrate thespecified repository.", restError=true, responseCode=401), @ResponseDoc(documentation="The specified repository does not exist.", restError=true, responseCode=404), @ResponseDoc(documentation="Setting or deleting merge configurations isn't supported on archived repositories.", restError=true, responseCode=409)})
    @POST
    @WebSudoRequired
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response setMergeConfig(@PathParam(value="scmId") String scmId, RestPullRequestSettings settings) {
        RestPullRequestMergeConfig mergeConfig = settings.getMergeConfig();
        if (mergeConfig != null && mergeConfig.isEmpty()) {
            this.pullRequestService.deleteMergeConfig(new DeletePullRequestMergeConfigRequest.Builder(scmId).build());
        } else {
            RestPullRequestMergeStrategy defaultStrategy = RestMergeConfigUtils.verifyDefaultStrategy(mergeConfig, this.i18nService);
            Set<String> mergeStrategyIds = RestMergeConfigUtils.getMergeStrategyIds(mergeConfig.getStrategies());
            this.pullRequestService.setMergeConfig(new SetPullRequestMergeConfigRequest.Builder(scmId).commitSummaries(mergeConfig.getCommitSummaries()).defaultStrategyId(defaultStrategy.getId()).enabledStrategyIds(mergeStrategyIds).build());
        }
        return ResponseFactory.ok((Object)this.readPullRequestSettings(scmId)).build();
    }

    private RestPullRequestSettings readPullRequestSettings(String scmId) {
        return new RestPullRequestSettings(new RestPullRequestMergeConfig(this.pullRequestService.getMergeConfig(new GetPullRequestMergeConfigRequest.Builder(scmId).build())));
    }
}

